/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.comparator;

import io.github.astrapi69.comparator.SortOrderComparator;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanPropertyComparator<T>
implements Comparator<T>,
Serializable {
    private final Comparator<?> comparator;
    private String property;

    public BeanPropertyComparator() {
        this(null);
    }

    public BeanPropertyComparator(String property) {
        this(property, SortOrderComparator.of());
    }

    public BeanPropertyComparator(String property, Comparator<?> comparator) {
        this.setProperty(property);
        this.comparator = comparator != null ? comparator : SortOrderComparator.of();
    }

    @Override
    public int compare(T o1, T o2) {
        if (this.property == null) {
            return this.internalCompare(o1, o2);
        }
        try {
            Object value1 = PropertyUtils.getProperty(o1, (String)this.property);
            Object value2 = PropertyUtils.getProperty(o2, (String)this.property);
            return this.internalCompare(value1, value2);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("IllegalAccessException: " + iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("InvocationTargetException: " + ite);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("NoSuchMethodException: " + e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanPropertyComparator)) {
            return false;
        }
        BeanPropertyComparator beanComparator = (BeanPropertyComparator)o;
        if (!this.comparator.equals(beanComparator.comparator)) {
            return false;
        }
        if (this.property != null) {
            return this.property.equals(beanComparator.property);
        }
        return beanComparator.property == null;
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public int hashCode() {
        int result = this.comparator.hashCode();
        return result;
    }

    private int internalCompare(Object val1, Object val2) {
        Comparator<?> internalComparator = this.comparator;
        return internalComparator.compare(val1, val2);
    }
}

