/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.compare.object;

import io.github.astrapi69.comparator.ComparatorExtensions;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.BeanUtils;

public final class CompareObjectExtensions {
    private CompareObjectExtensions() {
    }

    public static boolean compare(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (sourceOjbect == null || objectToCompare == null || !sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Object should not be null and be the same type.");
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        for (Object key : beanDescription.keySet()) {
            if (CompareObjectExtensions.compareTo(sourceOjbect, objectToCompare, key.toString()) == 0) continue;
            return false;
        }
        return true;
    }

    public static int compare(Object sourceOjbect, Object objectToCompare, String ... properties) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return CompareObjectExtensions.compareTo(sourceOjbect, objectToCompare, new HashSet<String>(Arrays.asList(properties)));
    }

    public static int compareTo(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Integer nullCheck = ComparatorExtensions.nullCheck((Object)sourceOjbect, (Object)objectToCompare);
        if (nullCheck != null) {
            return nullCheck;
        }
        if (!sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Object should be the same type.");
        }
        if (sourceOjbect instanceof Comparable && objectToCompare instanceof Comparable) {
            return ((Comparable)sourceOjbect).compareTo(objectToCompare);
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        int result = 0;
        for (Object key : beanDescription.keySet()) {
            result += CompareObjectExtensions.compareTo(sourceOjbect, objectToCompare, key.toString());
        }
        return result;
    }

    public static int compareTo(Object sourceOjbect, Object objectToCompare, Set<String> properties) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int result = 0;
        for (String property : properties) {
            result += CompareObjectExtensions.compareTo(sourceOjbect, objectToCompare, property);
        }
        return result;
    }

    public static int compareTo(Object sourceOjbect, Object objectToCompare, String property) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Integer nullCheck = ComparatorExtensions.nullCheck((Object)((String)BeanUtils.describe((Object)sourceOjbect).get(property)), (Object)((String)BeanUtils.describe((Object)objectToCompare).get(property)));
        if (nullCheck != null) {
            return nullCheck;
        }
        return new BeanComparator(property).compare(sourceOjbect, objectToCompare);
    }

    public static Map<String, Integer> getCompareToResult(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (sourceOjbect == null || objectToCompare == null || !sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Object should not be null and be the same type.");
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        HashMap<String, Integer> compareResult = new HashMap<String, Integer>();
        for (Object key : beanDescription.keySet()) {
            compareResult.put(key.toString(), CompareObjectExtensions.compareTo(sourceOjbect, objectToCompare, key.toString()));
        }
        return compareResult;
    }
}

