/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.reflection;

import io.github.astrapi69.lang.ClassExtensions;
import io.github.astrapi69.lang.ClassType;
import io.github.astrapi69.lang.ObjectExtensions;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public final class ReflectionExtensions {
    private static final Logger log = Logger.getLogger(ReflectionExtensions.class.getName());

    public static <T> T[] newArrayInstance(@NonNull Class<T> cls, int length) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return (Object[])Array.newInstance(cls, length);
    }

    public static Object newArray(@NonNull Class<?> cls, int length) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        if (!cls.isArray()) {
            return null;
        }
        Object destinationArray = null;
        Class<?> arrayType = cls.getComponentType();
        if (arrayType.isPrimitive()) {
            if ("boolean".equals(arrayType.getName())) {
                destinationArray = new boolean[length];
            }
            if ("byte".equals(arrayType.getName())) {
                destinationArray = new byte[length];
            }
            if ("char".equals(arrayType.getName())) {
                destinationArray = new char[length];
            }
            if ("short".equals(arrayType.getName())) {
                destinationArray = new short[length];
            }
            if ("int".equals(arrayType.getName())) {
                destinationArray = new int[length];
            }
            if ("long".equals(arrayType.getName())) {
                destinationArray = new long[length];
            }
            if ("float".equals(arrayType.getName())) {
                destinationArray = new float[length];
            }
            if ("double".equals(arrayType.getName())) {
                destinationArray = new double[length];
            }
        } else {
            destinationArray = Array.newInstance(cls, length);
        }
        return destinationArray;
    }

    public static <T> T[] newEmptyArrayInstance(@NonNull T[] source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return ReflectionExtensions.newArrayInstance(source.getClass().getComponentType(), source.length);
    }

    public static <T> T[] copyArray(@NonNull T[] source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        Object[] copyOfArray = (Object[])ReflectionExtensions.copyOfArray(source);
        return copyOfArray;
    }

    public static Object copyOfArray(Object source) {
        if (!source.getClass().isArray()) {
            return null;
        }
        Object destinationArray = null;
        Class<?> arrayType = source.getClass().getComponentType();
        if (arrayType.isPrimitive()) {
            if ("boolean".equals(arrayType.getName())) {
                destinationArray = Arrays.copyOf((boolean[])source, Array.getLength(source));
            }
            if ("byte".equals(arrayType.getName())) {
                destinationArray = Arrays.copyOf((byte[])source, Array.getLength(source));
            }
            if ("char".equals(arrayType.getName())) {
                destinationArray = Arrays.copyOf((char[])source, Array.getLength(source));
            }
            if ("short".equals(arrayType.getName())) {
                destinationArray = Arrays.copyOf((short[])source, Array.getLength(source));
            }
            if ("int".equals(arrayType.getName())) {
                destinationArray = Arrays.copyOf((int[])source, Array.getLength(source));
            }
            if ("long".equals(arrayType.getName())) {
                destinationArray = Arrays.copyOf((long[])source, Array.getLength(source));
            }
            if ("float".equals(arrayType.getName())) {
                destinationArray = Arrays.copyOf((float[])source, Array.getLength(source));
            }
            if ("double".equals(arrayType.getName())) {
                destinationArray = Arrays.copyOf((double[])source, Array.getLength(source));
            }
        } else {
            destinationArray = Array.newInstance(arrayType, Array.getLength(source));
            for (int i = 0; i < Array.getLength(source); ++i) {
                Array.set(destinationArray, i, Array.get(source, i));
            }
        }
        return destinationArray;
    }

    public static <ORIGINAL, DESTINATION> boolean copyFieldValue(@NonNull ORIGINAL source, @NonNull DESTINATION target, @NonNull Field field) throws IllegalAccessException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        field.setAccessible(true);
        Object newValue = field.get(source);
        if (newValue == null || Modifier.isFinal(field.getModifiers())) {
            return true;
        }
        ReflectionExtensions.setFieldValue(target, field, newValue);
        return false;
    }

    public static <T> void copyFieldValue(@NonNull T source, @NonNull T target, @NonNull String fieldName) throws NoSuchFieldException, SecurityException, IllegalAccessException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        ReflectionExtensions.setFieldValue(source, target, ReflectionExtensions.getDeclaredField(source, fieldName));
    }

    public static <T> void setFieldValue(@NonNull T source, @NonNull T target, @NonNull Field sourceField) throws IllegalAccessException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (sourceField == null) {
            throw new NullPointerException("sourceField is marked non-null but is null");
        }
        sourceField.setAccessible(true);
        Object sourceValue = sourceField.get(source);
        ReflectionExtensions.setFieldValue(target, sourceField, sourceValue);
    }

    public static <T> void setFieldValue(T target, Field sourceField, Object sourceValue) throws IllegalAccessException {
        sourceField.setAccessible(true);
        Class<?> fieldType = sourceField.getType();
        ClassType classType = ObjectExtensions.getClassType(fieldType);
        switch (classType) {
            case ARRAY: {
                sourceField.set(target, ReflectionExtensions.copyOfArray(sourceValue));
                break;
            }
            case ENUM: {
                sourceField.set(target, ReflectionExtensions.copyOfEnumValue(sourceValue, fieldType));
                break;
            }
            default: {
                sourceField.set(target, sourceValue);
            }
        }
    }

    public static Object copyOfEnumValue(Object value, Class<?> fieldType) {
        ClassType classType = ObjectExtensions.getClassType(fieldType);
        if (classType.equals((Object)ClassType.ENUM)) {
            Enum enumValue = (Enum)value;
            String name = enumValue.name();
            return Enum.valueOf(fieldType.asSubclass(Enum.class), name);
        }
        return null;
    }

    public static <T> Object getFieldValue(@NonNull T source, @NonNull String fieldName) throws NoSuchFieldException, SecurityException, IllegalAccessException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        Field sourceField = ReflectionExtensions.getDeclaredField(source, fieldName);
        sourceField.setAccessible(true);
        return sourceField.get(source);
    }

    public static <T> void setFieldValue(@NonNull Class<?> cls, @NonNull String fieldName, Object newValue) throws NoSuchFieldException, SecurityException, IllegalAccessException {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        Field sourceField = ReflectionExtensions.getDeclaredField(cls, fieldName);
        sourceField.setAccessible(true);
        sourceField.set(null, newValue);
    }

    public static List<String> getFieldNames(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return Arrays.stream(cls.getDeclaredFields()).filter(ReflectionExtensions::isNotSynthetic).map(Field::getName).collect(Collectors.toList());
    }

    public static List<String> getFieldNames(@NonNull Class<?> cls, List<String> ignoreFieldNames) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return Arrays.stream(cls.getDeclaredFields()).filter(ReflectionExtensions::isNotSynthetic).map(Field::getName).filter(name -> !ignoreFieldNames.contains(name)).collect(Collectors.toList());
    }

    public static List<String> getFieldNames(@NonNull Class<?> cls, String ... ignoreFieldNames) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return ReflectionExtensions.getFieldNames(cls, Arrays.asList(ignoreFieldNames));
    }

    public static String[] getDeclaredFieldNames(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return (String[])Arrays.stream(cls.getDeclaredFields()).filter(ReflectionExtensions::isNotSynthetic).map(Field::getName).toArray(String[]::new);
    }

    public static String[] getDeclaredFieldNames(@NonNull Class<?> cls, String ... ignoreFieldNames) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return ReflectionExtensions.getDeclaredFieldNames(cls, Arrays.asList(ignoreFieldNames));
    }

    public static String[] getDeclaredFieldNames(@NonNull Class<?> cls, List<String> ignoreFieldNames) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return (String[])Arrays.stream(cls.getDeclaredFields()).filter(ReflectionExtensions::isNotSynthetic).map(Field::getName).filter(name -> !ignoreFieldNames.contains(name)).toArray(String[]::new);
    }

    public static boolean isNotSynthetic(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return !field.isSynthetic();
    }

    public static String[] getMethodNames(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        Method[] methods = cls.getDeclaredMethods();
        String[] methodNames = new String[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            methodNames[i] = methods[i].getName();
        }
        return methodNames;
    }

    public static Map<String, String> getMethodNamesWithPrefixFromFieldNames(@NonNull List<String> fieldNames, String prefix) {
        if (fieldNames == null) {
            throw new NullPointerException("fieldNames is marked non-null but is null");
        }
        HashMap<String, String> fieldNameMethodMapper = new HashMap<String, String>();
        for (String fieldName : fieldNames) {
            String firstCharacterToUpperCasefieldName = ReflectionExtensions.firstCharacterToUpperCase(fieldName);
            String methodName = prefix + firstCharacterToUpperCasefieldName;
            fieldNameMethodMapper.put(fieldName, methodName);
        }
        return fieldNameMethodMapper;
    }

    public static String firstCharacterToUpperCase(@NonNull String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        String firstCharacter = fieldName.substring(0, 1);
        firstCharacter = firstCharacter.toUpperCase();
        char[] fc = firstCharacter.toCharArray();
        char[] fn = fieldName.toCharArray();
        fn[0] = fc[0];
        return new String(fn);
    }

    public static List<String> getModifiers(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        String modifiers = Modifier.toString(field.getModifiers());
        String[] modifiersArray = modifiers.split(" ");
        return Arrays.asList(modifiersArray);
    }

    public static <T> T newInstance(@NonNull T object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        Class<?> clazz = object.getClass();
        ClassType classType = ClassExtensions.getClassType(clazz);
        switch (classType) {
            case MAP: {
                if (clazz.equals(Map.class)) {
                    return (T)new HashMap();
                }
            }
            case COLLECTION: {
                if (clazz.equals(Set.class)) {
                    return (T)new HashSet();
                }
                if (clazz.equals(List.class)) {
                    return (T)new ArrayList();
                }
                if (clazz.equals(Queue.class)) {
                    return (T)new LinkedList();
                }
            }
            case ARRAY: {
                int length = Array.getLength(object);
                return (T)Array.newInstance(clazz.getComponentType(), length);
            }
        }
        return (T)ReflectionExtensions.newInstance(object.getClass());
    }

    public static <T> T newInstance(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        T newInstance = null;
        Optional<T> optionalNewInstance = ReflectionExtensions.forceNewInstanceWithClass(clazz);
        if (optionalNewInstance.isPresent()) {
            return optionalNewInstance.get();
        }
        optionalNewInstance = ReflectionExtensions.forceNewInstanceWithObjenesis(clazz);
        if (optionalNewInstance.isPresent()) {
            return optionalNewInstance.get();
        }
        return newInstance;
    }

    private static <T> Optional<T> forceNewInstanceWithClass(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Optional optionalNewInstance = Optional.empty();
        try {
            optionalNewInstance = Optional.of(ReflectionExtensions.newInstanceWithClass(clazz));
        }
        catch (Error | Exception e) {
            log.log(Level.INFO, "Failed to create new instance with method Class.newInstance()", e);
        }
        return optionalNewInstance;
    }

    private static <T> Optional<T> forceNewInstanceWithObjenesis(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Optional optionalNewInstance = Optional.empty();
        try {
            optionalNewInstance = Optional.of(ReflectionExtensions.newInstanceWithObjenesis(clazz));
        }
        catch (Error | Exception e) {
            log.log(Level.INFO, "Failed to create new instance with Objenesis ObjectInstantiator.newInstance()", e);
        }
        return optionalNewInstance;
    }

    public static <T> T newInstanceWithClass(@NonNull Class<T> clazz) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        ClassType classType = ClassExtensions.getClassType(clazz);
        switch (classType) {
            case MAP: {
                if (clazz.equals(Map.class)) {
                    return (T)new HashMap();
                }
            }
            case COLLECTION: {
                if (clazz.equals(Set.class)) {
                    return (T)new HashSet();
                }
                if (clazz.equals(List.class)) {
                    return (T)new ArrayList();
                }
                if (clazz.equals(Queue.class)) {
                    return (T)new LinkedList();
                }
            }
            case ARRAY: {
                int length = 3;
                return (T)Array.newInstance(clazz.getComponentType(), length);
            }
        }
        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static <T> T newInstanceWithObjenesis(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        ObjenesisStd objenesis = new ObjenesisStd();
        ObjectInstantiator instantiator = objenesis.getInstantiatorOf(clazz);
        return (T)instantiator.newInstance();
    }

    public static <T> Field getDeclaredField(@NonNull T object, @NonNull String fieldName) throws NoSuchFieldException, SecurityException {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        return ReflectionExtensions.getDeclaredField(object.getClass(), fieldName);
    }

    public static Field getDeclaredField(@NonNull Class<?> cls, @NonNull String fieldName) throws NoSuchFieldException, SecurityException {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        return cls.getDeclaredField(fieldName);
    }

    public static Field[] getAllDeclaredFields(@NonNull Class<?> cls, String ... ignoreFieldNames) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return ReflectionExtensions.getAllDeclaredFields(cls, Arrays.asList(ignoreFieldNames));
    }

    public static String[] getDefaultIgnoreFieldNames() {
        return new String[]{"serialVersionUID", "$jacocoData"};
    }

    public static Field[] getAllDeclaredFields(@NonNull Class<?> cls, List<String> ignoreFieldNames) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        Field[] declaredFields = ReflectionExtensions.getDeclaredFields(cls, ignoreFieldNames);
        Class<?> superClass = cls.getSuperclass();
        if (superClass != null && superClass.equals(Object.class)) {
            return declaredFields;
        }
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(declaredFields));
        while (!(superClass == null || superClass.getSuperclass() != null && superClass.equals(Object.class))) {
            fields.addAll(Arrays.asList(ReflectionExtensions.getDeclaredFields(superClass, ignoreFieldNames)));
            superClass = superClass.getSuperclass();
        }
        return fields.toArray(ReflectionExtensions.newArrayInstance(Field.class, fields.size()));
    }

    public static String[] getAllDeclaredFieldNames(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return (String[])Arrays.stream(ReflectionExtensions.getAllDeclaredFields(cls, new String[0])).map(Field::getName).toArray(String[]::new);
    }

    public static String[] getAllDeclaredFieldNames(@NonNull Class<?> cls, String ... ignoreFieldNames) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return ReflectionExtensions.getAllDeclaredFieldNames(cls, Arrays.asList(ignoreFieldNames));
    }

    public static String[] getAllDeclaredFieldNames(@NonNull Class<?> cls, List<String> ignoreFieldNames) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        Field[] allDeclaredFields = ReflectionExtensions.getAllDeclaredFields(cls, ignoreFieldNames);
        return (String[])Arrays.stream(allDeclaredFields).map(Field::getName).filter(name -> !ignoreFieldNames.contains(name)).toArray(String[]::new);
    }

    public static Field[] getDeclaredFields(@NonNull Class<?> cls, List<String> ignoreFieldNames) throws SecurityException {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        Field[] declaredFields = cls.getDeclaredFields();
        return (Field[])Arrays.stream(declaredFields).filter(field -> !ignoreFieldNames.contains(field.getName())).toArray(Field[]::new);
    }

    public static Field[] getDeclaredFields(@NonNull Class<?> cls, String ... ignoreFieldNames) throws SecurityException {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return ReflectionExtensions.getDeclaredFields(cls, Arrays.asList(ignoreFieldNames));
    }

    private ReflectionExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

