/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.astrapi69.json.JsonStringToObjectExtensions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public final class JSONObjectToObjectExtensions {
    private JSONObjectToObjectExtensions() {
    }

    public static <T> T toObject(JSONObject jsonObject, Class<T> clazz, ObjectMapper mapper) throws IOException {
        Objects.requireNonNull(jsonObject);
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(mapper);
        return JsonStringToObjectExtensions.toObject(jsonObject.toString(), clazz, mapper);
    }

    public static <T> List<T> toObjectList(JSONArray jsonArray, Class<T> elementClass) throws IOException {
        Objects.requireNonNull(jsonArray);
        Objects.requireNonNull(elementClass);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object object = jsonArray.get(i);
            list.add(object.toString());
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            result.add(JsonStringToObjectExtensions.toObject((String)list.get(i), elementClass));
        }
        return result;
    }
}

