/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.astrapi69.json.factory.ObjectMapperFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JsonFileToObjectExtensions {
    private JsonFileToObjectExtensions() {
    }

    public static <K, V> Map<K, V> toMapObject(File jsonFile, TypeReference<Map<K, V>> typeReference) throws IOException {
        Objects.requireNonNull(jsonFile);
        Objects.requireNonNull(typeReference);
        return JsonFileToObjectExtensions.toMapObject(jsonFile, typeReference, ObjectMapperFactory.newObjectMapper(true));
    }

    public static <K, V> Map<K, V> toMapObject(File jsonFile, TypeReference<Map<K, V>> typeReference, ObjectMapper mapper) throws IOException {
        Objects.requireNonNull(jsonFile);
        Objects.requireNonNull(typeReference);
        Objects.requireNonNull(mapper);
        return (Map)mapper.readValue(jsonFile, typeReference);
    }

    public static <T> T toObject(File jsonFile, Class<T> clazz) throws IOException {
        return JsonFileToObjectExtensions.toObject(jsonFile, clazz, ObjectMapperFactory.newObjectMapper());
    }

    public static <T> T toObject(File jsonFile, Class<T> clazz, ObjectMapper mapper) throws IOException {
        Objects.requireNonNull(jsonFile);
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(mapper);
        return (T)mapper.readValue(jsonFile, clazz);
    }

    public static <T> T toObject(File jsonFile, TypeReference<T> typeReference, ObjectMapper mapper) throws IOException {
        Objects.requireNonNull(jsonFile);
        Objects.requireNonNull(typeReference);
        Objects.requireNonNull(mapper);
        return (T)mapper.readValue(jsonFile, typeReference);
    }

    public static <T> Collection<T> toObjectCollection(File jsonFile, Class<? extends Collection> collectionClass, Class<T> elementClass) throws IOException {
        Objects.requireNonNull(jsonFile);
        Objects.requireNonNull(collectionClass);
        Objects.requireNonNull(elementClass);
        ObjectMapper mapper = ObjectMapperFactory.newObjectMapper(true);
        return (Collection)mapper.readValue(jsonFile, (JavaType)mapper.getTypeFactory().constructCollectionType(collectionClass, elementClass));
    }

    public static <T> List<T> toObjectList(File jsonFile, Class<T> elementClass) throws IOException {
        Objects.requireNonNull(jsonFile);
        Objects.requireNonNull(elementClass);
        return (List)JsonFileToObjectExtensions.toObjectCollection(jsonFile, List.class, elementClass);
    }
}

