/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.json;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.github.astrapi69.json.factory.CustomJsonNodeFactory;
import io.github.astrapi69.json.factory.CustomParserFactory;
import io.github.astrapi69.json.factory.ObjectMapperFactory;
import java.io.File;
import java.io.IOException;

public final class JsonLineNumberResolver {
    private JsonLineNumberResolver() {
    }

    public static int getLineNumber(File jsonFile, String jsonPath) throws IOException {
        int lineNumber = -1;
        CustomParserFactory customParserFactory = new CustomParserFactory();
        ObjectMapper objectMapper = ObjectMapperFactory.newObjectMapper(customParserFactory);
        CustomJsonNodeFactory factory = JsonLineNumberResolver.newCustomJsonNodeFactory(objectMapper, customParserFactory);
        Configuration configuration = JsonLineNumberResolver.newLineNumberConfiguration(objectMapper);
        DocumentContext parsedDocument = JsonPath.parse((File)jsonFile, (Configuration)configuration);
        ArrayNode findings = (ArrayNode)parsedDocument.read(jsonPath, new Predicate[0]);
        if (findings.size() == 1) {
            for (JsonNode finding : findings) {
                JsonLocation location = factory.getLocationForNode(finding);
                lineNumber = location.getLineNr();
            }
        }
        return lineNumber;
    }

    private static CustomJsonNodeFactory newCustomJsonNodeFactory(ObjectMapper objectMapper, CustomParserFactory customParserFactory) {
        CustomJsonNodeFactory factory = new CustomJsonNodeFactory(objectMapper.getDeserializationConfig().getNodeFactory(), customParserFactory);
        objectMapper.setConfig(objectMapper.getDeserializationConfig().with((JsonNodeFactory)factory));
        return factory;
    }

    private static Configuration newLineNumberConfiguration(ObjectMapper objectMapper) {
        return Configuration.builder().mappingProvider((MappingProvider)new JacksonMappingProvider(objectMapper)).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider(objectMapper)).options(new Option[]{Option.ALWAYS_RETURN_LIST}).build();
    }
}

