/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.astrapi69.json.factory.ObjectMapperFactory;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public final class ObjectToJsonFileExtensions {
    private ObjectToJsonFileExtensions() {
    }

    public static <T> void toJsonFile(T object, File resultFile) throws IOException {
        Objects.requireNonNull(object);
        Objects.requireNonNull(resultFile);
        ObjectToJsonFileExtensions.toJsonFile(object, resultFile, false);
    }

    public static <T> void toJsonFile(T object, File resultFile, boolean newMapper) throws IOException {
        Objects.requireNonNull(object);
        Objects.requireNonNull(resultFile);
        ObjectMapper mapper = ObjectMapperFactory.newObjectMapper(newMapper);
        ObjectToJsonFileExtensions.toJsonFile(object, resultFile, mapper);
    }

    public static <T> void toJsonFile(T object, File resultFile, ObjectMapper mapper) throws IOException {
        Objects.requireNonNull(object);
        Objects.requireNonNull(resultFile);
        Objects.requireNonNull(mapper);
        mapper.writeValue(resultFile, object);
    }
}

