/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.json.factory;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.databind.util.RawValue;
import io.github.astrapi69.json.factory.CustomParserFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomJsonNodeFactory
extends JsonNodeFactory {
    private static final long serialVersionUID = 8807395553661461181L;
    private final JsonNodeFactory delegate;
    private final CustomParserFactory parserFactory;
    private final List<Map.Entry<JsonNode, JsonLocation>> locationMapping;

    public CustomJsonNodeFactory(JsonNodeFactory nodeFactory, CustomParserFactory parserFactory) {
        this.delegate = nodeFactory;
        this.parserFactory = parserFactory;
        this.locationMapping = new ArrayList<Map.Entry<JsonNode, JsonLocation>>();
    }

    public JsonLocation getLocationForNode(JsonNode jsonNode) {
        return this.locationMapping.stream().filter(e -> ((JsonNode)e.getKey()).equals((Object)jsonNode)).map(e -> (JsonLocation)e.getValue()).findAny().orElse(null);
    }

    private <T extends JsonNode> T markNode(T node) {
        JsonLocation loc = this.parserFactory.getParser().getCurrentLocation();
        this.locationMapping.add(new AbstractMap.SimpleEntry<T, JsonLocation>(node, loc));
        return node;
    }

    public BooleanNode booleanNode(boolean v) {
        return this.markNode(this.delegate.booleanNode(v));
    }

    public NullNode nullNode() {
        return this.markNode(this.delegate.nullNode());
    }

    public NumericNode numberNode(byte v) {
        return this.markNode(this.delegate.numberNode(v));
    }

    public ValueNode numberNode(Byte value) {
        return this.markNode(this.delegate.numberNode(value));
    }

    public NumericNode numberNode(short v) {
        return this.markNode(this.delegate.numberNode(v));
    }

    public ValueNode numberNode(Short value) {
        return this.markNode(this.delegate.numberNode(value));
    }

    public NumericNode numberNode(int v) {
        return this.markNode(this.delegate.numberNode(v));
    }

    public ValueNode numberNode(Integer value) {
        return this.markNode(this.delegate.numberNode(value));
    }

    public NumericNode numberNode(long v) {
        return this.markNode(this.delegate.numberNode(v));
    }

    public ValueNode numberNode(Long value) {
        return this.markNode(this.delegate.numberNode(value));
    }

    public ValueNode numberNode(BigInteger v) {
        return this.markNode(this.delegate.numberNode(v));
    }

    public NumericNode numberNode(float v) {
        return this.markNode(this.delegate.numberNode(v));
    }

    public ValueNode numberNode(Float value) {
        return this.markNode(this.delegate.numberNode(value));
    }

    public NumericNode numberNode(double v) {
        return this.markNode(this.delegate.numberNode(v));
    }

    public ValueNode numberNode(Double value) {
        return this.markNode(this.delegate.numberNode(value));
    }

    public ValueNode numberNode(BigDecimal v) {
        return this.markNode(this.delegate.numberNode(v));
    }

    public TextNode textNode(String text) {
        return this.markNode(this.delegate.textNode(text));
    }

    public BinaryNode binaryNode(byte[] data) {
        return this.markNode(this.delegate.binaryNode(data));
    }

    public BinaryNode binaryNode(byte[] data, int offset, int length) {
        return this.markNode(this.delegate.binaryNode(data, offset, length));
    }

    public ValueNode pojoNode(Object pojo) {
        return this.markNode(this.delegate.pojoNode(pojo));
    }

    public ValueNode rawValueNode(RawValue value) {
        return this.markNode(this.delegate.rawValueNode(value));
    }

    public ArrayNode arrayNode() {
        return this.markNode(this.delegate.arrayNode());
    }

    public ArrayNode arrayNode(int capacity) {
        return this.markNode(this.delegate.arrayNode(capacity));
    }

    public ObjectNode objectNode() {
        return this.markNode(this.delegate.objectNode());
    }
}

