/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.browser;

import io.github.astrapi69.browser.Browsers;
import io.github.astrapi69.browser.OS;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.JOptionPane;

public class BrowserControlExtensions {
    private static final String MAC_FILE_MANAGER = "com.apple.eio.FileManager";
    private static final String UNIX_COMMAND_WHICH = "which";
    private static final String WINDOWS_FLAG = "url.dll,FileProtocolHandler";
    private static final String WINDOWS_PATH = "rundll32";

    public static Object displayURLonStandardBrowser(String url) {
        Object obj = OS.isMac() ? RuntimeExceptionDecorator.decorate(() -> BrowserControlExtensions.openURLinMacOS(url)) : (OS.isWindows() ? RuntimeExceptionDecorator.decorate(() -> BrowserControlExtensions.openURLinWindowsOS(url)) : RuntimeExceptionDecorator.decorate(() -> BrowserControlExtensions.openURLinUnixOS(url)));
        return obj;
    }

    public static Object displayURLonStandardBrowser(Component parentComponent, String url) {
        Object obj = null;
        try {
            obj = BrowserControlExtensions.displayURLonStandardBrowser(url);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(parentComponent, "An exception occured attempting to run the default web browser\n" + e);
        }
        return obj;
    }

    private static Object openURLinMacOS(String url) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> fileManagerClass = Class.forName(MAC_FILE_MANAGER);
        Method openURL = fileManagerClass.getDeclaredMethod("openURL", String.class);
        return openURL.invoke(null, url);
    }

    private static Boolean openURLinUnixOS(String url) throws InterruptedException, IOException, Exception {
        boolean executed = false;
        for (Browsers browser : Browsers.values()) {
            if (executed) continue;
            boolean bl = executed = Runtime.getRuntime().exec(new String[]{UNIX_COMMAND_WHICH, browser.getBrowserName()}).waitFor() == 0;
            if (!executed) continue;
            Runtime.getRuntime().exec(new String[]{browser.getBrowserName(), url});
        }
        if (!executed) {
            throw new Exception(Arrays.toString((Object[])Browsers.values()));
        }
        return executed;
    }

    private static Process openURLinWindowsOS(String url) throws IOException {
        String cmd = "rundll32 url.dll,FileProtocolHandler ";
        return Runtime.getRuntime().exec(cmd + url);
    }
}

