/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.browser;

import java.util.regex.Pattern;

public enum OS {
    LINUX("Linux"),
    MAC("Mac OS"),
    OTHER("Other"),
    UNIX("Unix"),
    WINDOWS("Windows");

    private static final Pattern LINUX_PATTERN;
    private static final Pattern MAC_PATTERN;
    private static final String OS_NAME = "os.name";
    private static final Pattern WINDOWS_PATTERN;
    private final String os;

    private OS(String os) {
        this.os = os;
    }

    public static OS get() {
        return OS.getOperatingSystem();
    }

    public static boolean isWindows() {
        return OS.getOperatingSystemName().startsWith(WINDOWS.getOs());
    }

    public static boolean isMac() {
        return OS.getOperatingSystemName().startsWith(MAC.getOs());
    }

    public static boolean isLinux() {
        return OS.getOperatingSystemName().startsWith(LINUX.getOs());
    }

    public static OS getOperatingSystem() {
        String osname = System.getProperty(OS_NAME);
        if (WINDOWS_PATTERN.matcher(osname).matches()) {
            return WINDOWS;
        }
        if (LINUX_PATTERN.matcher(osname).matches()) {
            return LINUX;
        }
        if (MAC_PATTERN.matcher(osname).matches()) {
            return MAC;
        }
        return OTHER;
    }

    public static String getOperatingSystemName() {
        return OS.get().getOs();
    }

    public String getOs() {
        return this.os;
    }

    static {
        LINUX_PATTERN = Pattern.compile(".*[L|l]inux.*");
        MAC_PATTERN = Pattern.compile("mac|darwin");
        WINDOWS_PATTERN = Pattern.compile(".*[W|w]indows.*");
    }
}

