/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public abstract class OpenFileAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final Component parent;
    private final JFileChooser fileChooser;

    public OpenFileAction(String name, Component parent) {
        super(name);
        Objects.requireNonNull(parent);
        this.parent = parent;
        this.fileChooser = this.newJFileChooser();
    }

    protected JFileChooser newJFileChooser() {
        return new JFileChooser();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.onFileChoose(this.fileChooser, actionEvent);
    }

    protected abstract void onApproveOption(File var1, ActionEvent var2);

    protected abstract void onCancel(ActionEvent var1);

    protected void onFileChoose(JFileChooser fileChooser, ActionEvent actionEvent) {
        int returnVal = fileChooser.showOpenDialog(this.parent);
        if (returnVal == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.onApproveOption(selectedFile, actionEvent);
        } else {
            this.onCancel(actionEvent);
        }
    }

    public Component getParent() {
        return this.parent;
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }
}

