/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.action;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import lombok.NonNull;

public class ShowHelpDialogAction
extends AbstractAction {
    private static final Logger log = Logger.getLogger(ShowHelpDialogAction.class.getName());
    private static final long serialVersionUID = 1L;
    private final Window helpWindow;
    private final String lookAndFeelsClassName;

    public ShowHelpDialogAction(String name, @NonNull Window helpWindow, @NonNull String lookAndFeelsClassName) {
        super(name);
        if (helpWindow == null) {
            throw new NullPointerException("helpWindow is marked non-null but is null");
        }
        if (lookAndFeelsClassName == null) {
            throw new NullPointerException("lookAndFeelsClassName is marked non-null but is null");
        }
        this.helpWindow = helpWindow;
        this.lookAndFeelsClassName = lookAndFeelsClassName;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.onShowHelpDialog(actionEvent);
    }

    protected void onShowHelpDialog(ActionEvent actionEvent) {
        this.helpWindow.setLocationRelativeTo(null);
        try {
            UIManager.setLookAndFeel(this.lookAndFeelsClassName);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
        SwingUtilities.updateComponentTreeUI(this.helpWindow);
    }

    public Window getHelpWindow() {
        return this.helpWindow;
    }

    public String getLookAndFeelsClassName() {
        return this.lookAndFeelsClassName;
    }
}

