/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.help;

import io.github.astrapi69.lang.ClassExtensions;
import io.github.astrapi69.swing.menu.factory.JMenuItemFactory;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.WindowPresentation;
import javax.swing.JMenuItem;
import lombok.NonNull;

public class HelpFactory {
    public static HelpSet newHelpSet(String directory, String filename) throws HelpSetException {
        String path = directory + "/" + filename;
        URL hsURL = ClassExtensions.getResource((String)path);
        HelpSet hs = hsURL != null ? new HelpSet(ClassExtensions.getClassLoader(), hsURL) : new HelpSet();
        return hs;
    }

    public static DefaultHelpBroker newHelpBroker(String directory, String filename) throws HelpSetException {
        HelpSet hs = HelpFactory.newHelpSet(directory, filename);
        DefaultHelpBroker helpBroker = (DefaultHelpBroker)hs.createHelpBroker();
        return helpBroker;
    }

    public static Window newHelpWindow(DefaultHelpBroker helpBroker) {
        WindowPresentation pres = helpBroker.getWindowPresentation();
        pres.createHelpWindow();
        Window helpWindow = pres.getHelpWindow();
        return helpWindow;
    }

    public static JMenuItem newHelpContent(@NonNull DefaultHelpBroker helpBroker, @NonNull String content, @NonNull String overview, char mnemonic, char accelerator) {
        if (helpBroker == null) {
            throw new NullPointerException("helpBroker is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (overview == null) {
            throw new NullPointerException("overview is marked non-null but is null");
        }
        JMenuItem miHelpContent = JMenuItemFactory.newJMenuItem(content, mnemonic, accelerator);
        CSH.setHelpIDString((Component)miHelpContent, (String)overview);
        CSH.DisplayHelpFromSource displayHelpFromSource = new CSH.DisplayHelpFromSource((HelpBroker)helpBroker);
        miHelpContent.addActionListener((ActionListener)displayHelpFromSource);
        return miHelpContent;
    }
}

