/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.listener.document;

import io.github.astrapi69.model.api.IModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import lombok.NonNull;

public class StringBindingListener
implements DocumentListener {
    private static final Logger log = Logger.getLogger(StringBindingListener.class.getName());
    private final IModel<String> model;

    public StringBindingListener(@NonNull IModel<String> model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.update(event);
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.update(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.update(event);
    }

    protected void update(DocumentEvent event) {
        try {
            String text = event.getDocument().getText(event.getDocument().getStartPosition().getOffset(), event.getDocument().getEndPosition().getOffset() - 1);
            this.model.setObject((Object)text);
        }
        catch (BadLocationException e1) {
            log.log(Level.SEVERE, "some portion of the given range was not a valid part of the document. The location in the exception is the first bad position encountered.", e1);
        }
    }

    public IModel<String> getModel() {
        return this.model;
    }
}

