/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.listener.mouse;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Timer;

public abstract class MouseDoubleClickListener
extends MouseAdapter
implements ActionListener {
    private static final String AWT_MULTI_CLICK_INTERVAL_KEY = "awt.multiClickInterval";
    private final Timer timer;
    private MouseEvent lastEvent;

    public MouseDoubleClickListener() {
        this((Integer)Toolkit.getDefaultToolkit().getDesktopProperty(AWT_MULTI_CLICK_INTERVAL_KEY));
    }

    public MouseDoubleClickListener(int delay) {
        this.timer = new Timer(delay, this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 2) {
            return;
        }
        this.lastEvent = mouseEvent;
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.onDoubleClick(this.lastEvent);
        } else {
            this.timer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.timer.stop();
        this.onSingleClick(this.lastEvent);
    }

    public abstract void onSingleClick(MouseEvent var1);

    public abstract void onDoubleClick(MouseEvent var1);
}

