/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.listener.mouse;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Timer;

public class MouseTripleClickCounterListener
extends MouseAdapter
implements ActionListener {
    MouseEvent lastEvent;
    Timer timer;
    int delay;
    private boolean leftClick;
    private boolean middleClick;
    private boolean rightClick;
    private boolean doubleClick;
    private boolean tripleClick;

    public MouseTripleClickCounterListener() {
        this((Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval"));
    }

    public MouseTripleClickCounterListener(int delay) {
        this.delay = delay;
        this.timer = new Timer(delay, this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setMouseButton(mouseEvent);
        if (mouseEvent.getClickCount() > 3) {
            this.timer.stop();
            this.tripleClick(this.lastEvent);
        }
        this.lastEvent = mouseEvent;
        if (mouseEvent.getClickCount() > 2) {
            return;
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.doubleClick(this.lastEvent);
        } else {
            this.timer.restart();
        }
    }

    private void setMouseButton(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.leftClick = true;
            this.middleClick = false;
            this.rightClick = false;
        }
        if (mouseEvent.getButton() == 2) {
            this.leftClick = false;
            this.middleClick = true;
            this.rightClick = false;
        }
        if (mouseEvent.getButton() == 3) {
            this.leftClick = false;
            this.middleClick = false;
            this.rightClick = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.timer.stop();
        this.singleClick(this.lastEvent);
    }

    public void singleClick(MouseEvent mouseEvent) {
    }

    public void doubleClick(MouseEvent mouseEvent) {
    }

    public void tripleClick(MouseEvent mouseEvent) {
    }
}

