/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.menu;

import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import lombok.NonNull;

public final class MenuExtensions {
    public static int toMnemonic(char charMnemonic) {
        int mnemonic = charMnemonic;
        if (mnemonic >= 97 && mnemonic <= 122) {
            mnemonic -= 32;
        }
        return mnemonic;
    }

    public static void setAccelerator(JMenuItem jmi, char keyChar) {
        jmi.setAccelerator(KeyStroke.getKeyStroke(keyChar));
    }

    public static void setMnemonic(JMenu menu, char keyChar) {
        menu.setMnemonic(keyChar);
    }

    public static void setMnemonic(JMenu menu, int mnemonic) {
        menu.setMnemonic(mnemonic);
    }

    public static void setMnemonic(JMenuItem menuItem, char keyChar) {
        menuItem.setMnemonic(keyChar);
    }

    public static void setMnemonic(JMenuItem menuItem, int mnemonic) {
        menuItem.setMnemonic(mnemonic);
    }

    public static void setAccelerator(JMenuItem jmi, Character keyChar, int modifiers) {
        MenuExtensions.setAccelerator(jmi, KeyStroke.getKeyStroke(keyChar, modifiers));
    }

    public static void setAccelerator(JMenuItem jmi, int keyCode, int modifiers) {
        MenuExtensions.setAccelerator(jmi, KeyStroke.getKeyStroke(keyCode, modifiers));
    }

    public static void setAccelerator(JMenuItem jmi, KeyStroke keyStroke) {
        jmi.setAccelerator(keyStroke);
    }

    public static void setAccelerator(JMenuItem jmi, int keyCode, int modifiers, boolean onKeyRelease) {
        MenuExtensions.setAccelerator(jmi, KeyStroke.getKeyStroke(keyCode, modifiers, onKeyRelease));
    }

    public static void setAccelerator(JMenuItem jmi, String parsableKeystrokeString) {
        MenuExtensions.setAccelerator(jmi, KeyStroke.getKeyStroke(parsableKeystrokeString));
    }

    public static void setAltAccelerator(JMenuItem jmi, char accelerator) {
        MenuExtensions.setAccelerator(jmi, (int)accelerator, 512);
    }

    public static void setCtrlAccelerator(JMenuItem jmi, char accelerator) {
        MenuExtensions.setAccelerator(jmi, (int)accelerator, 128);
    }

    public static void addActionListener(@NonNull JMenuItem menuItem, @NonNull ActionListener actionListener) {
        if (menuItem == null) {
            throw new NullPointerException("menuItem is marked non-null but is null");
        }
        if (actionListener == null) {
            throw new NullPointerException("actionListener is marked non-null but is null");
        }
        menuItem.addActionListener(actionListener);
    }

    public static JMenuItem addMenuItem(@NonNull JMenu menu, @NonNull JMenuItem menuItem) {
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        if (menuItem == null) {
            throw new NullPointerException("menuItem is marked non-null but is null");
        }
        return menu.add(menuItem);
    }

    public static JMenuItem addMenuItem(@NonNull JMenu menu, @NonNull JMenuItem menuItem, @NonNull ActionListener actionListener) {
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        if (menuItem == null) {
            throw new NullPointerException("menuItem is marked non-null but is null");
        }
        if (actionListener == null) {
            throw new NullPointerException("actionListener is marked non-null but is null");
        }
        JMenuItem jMenuItem = MenuExtensions.addMenuItem(menu, menuItem);
        MenuExtensions.addActionListener(jMenuItem, actionListener);
        return jMenuItem;
    }

    public static JMenuItem addMenuItem(@NonNull JMenu menu, @NonNull JMenuItem menuItem, @NonNull KeyStroke keyStroke, @NonNull ActionListener actionListener) {
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        if (menuItem == null) {
            throw new NullPointerException("menuItem is marked non-null but is null");
        }
        if (keyStroke == null) {
            throw new NullPointerException("keyStroke is marked non-null but is null");
        }
        if (actionListener == null) {
            throw new NullPointerException("actionListener is marked non-null but is null");
        }
        JMenuItem jMenuItem = MenuExtensions.addMenuItem(menu, menuItem);
        jMenuItem.setAccelerator(keyStroke);
        MenuExtensions.addActionListener(jMenuItem, actionListener);
        return jMenuItem;
    }
}

