/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.menu;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import lombok.NonNull;

public final class ParentMenuResolver {
    private ParentMenuResolver() {
    }

    public static Optional<Class<?>> getMenuElementType(@NonNull MenuElement menuElement) {
        if (menuElement == null) {
            throw new NullPointerException("menuElement is marked non-null but is null");
        }
        Component component = menuElement.getComponent();
        if (component instanceof JMenu) {
            return Optional.of(JMenu.class);
        }
        if (component instanceof JMenuBar) {
            return Optional.of(JMenuBar.class);
        }
        if (component instanceof JMenuItem) {
            return Optional.of(JMenuItem.class);
        }
        if (component instanceof JCheckBoxMenuItem) {
            return Optional.of(JCheckBoxMenuItem.class);
        }
        if (component instanceof JRadioButtonMenuItem) {
            return Optional.of(JRadioButtonMenuItem.class);
        }
        return Optional.of(JPopupMenu.class);
    }

    public static List<MenuElement> getChildMenuElements(@NonNull MenuElement parent) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        Component parentMenu = parent.getComponent();
        if (parentMenu instanceof JMenuBar) {
            JMenuBar jMenuBar = (JMenuBar)parentMenu;
            MenuElement[] subElements = jMenuBar.getSubElements();
            return Arrays.asList(subElements);
        }
        List<MenuElement> allMenuElements = ParentMenuResolver.getAllMenuElements(parent);
        ArrayList<MenuElement> childMenuElements = new ArrayList<MenuElement>();
        for (MenuElement menuElement : allMenuElements) {
            Component component = menuElement.getComponent();
            if (component instanceof JMenu) {
                JMenu jMenu = (JMenu)component;
                ParentMenuResolver.addChildMenuElement(parentMenu, childMenuElements, menuElement, jMenu.getParent());
                continue;
            }
            if (!(component instanceof JMenuItem)) continue;
            JMenuItem jMenuItem = (JMenuItem)component;
            ParentMenuResolver.addChildMenuElement(parentMenu, childMenuElements, menuElement, jMenuItem.getParent());
        }
        return childMenuElements;
    }

    private static void addChildMenuElement(Component parentMenu, List<MenuElement> childMenuElements, MenuElement menuElement, Container menuParent) {
        JPopupMenu jPopupMenu;
        Component invoker;
        if (menuParent instanceof JPopupMenu && (invoker = (jPopupMenu = (JPopupMenu)menuParent).getInvoker()).equals(parentMenu) && !childMenuElements.contains(menuElement)) {
            childMenuElements.add(menuElement);
        }
    }

    public static List<MenuElement> getAllMenuElements(@NonNull MenuElement parent) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        return ParentMenuResolver.getAllMenuElements(parent, false);
    }

    public static List<MenuElement> getAllMenuElements(@NonNull MenuElement parent, boolean withoutPopupMenu) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        return ParentMenuResolver.getAllMenuElements(parent, withoutPopupMenu, true);
    }

    public static List<MenuElement> getAllMenuElements(@NonNull MenuElement parent, boolean withoutPopupMenu, boolean recursive) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        ArrayList<MenuElement> menuElements = new ArrayList<MenuElement>();
        for (MenuElement menuElement : parent.getSubElements()) {
            if (!withoutPopupMenu || !(menuElement instanceof JPopupMenu)) {
                menuElements.add(menuElement);
            }
            if (!recursive) continue;
            menuElements.addAll(ParentMenuResolver.getAllMenuElements(menuElement, withoutPopupMenu, true));
        }
        return menuElements;
    }

    public static Optional<Container> getRootJMenu(@NonNull JMenuItem menu) {
        boolean iterate;
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        Optional<Container> current = Optional.empty();
        Container previous = menu;
        Container containerParent = previous.getParent();
        boolean bl = iterate = containerParent != null;
        if (!iterate) {
            current = Optional.of(menu);
        }
        while (iterate) {
            if (containerParent instanceof JPopupMenu) {
                JPopupMenu popupMenu = (JPopupMenu)containerParent;
                Component invoker = popupMenu.getInvoker();
                if (invoker instanceof JMenu) {
                    containerParent = (JMenu)invoker;
                }
            } else {
                if (containerParent instanceof JMenuBar) {
                    current = Optional.of(previous);
                    break;
                }
                if (containerParent instanceof JToolBar) {
                    current = Optional.of(previous);
                    break;
                }
            }
            if (containerParent.getParent() != null) {
                previous = containerParent;
                containerParent = containerParent.getParent();
                continue;
            }
            if (containerParent instanceof JMenu) {
                current = Optional.of(containerParent);
            }
            iterate = false;
        }
        return current;
    }

    public static Optional<Container> getRoot(@NonNull JMenuItem menu) {
        boolean iterate;
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        Optional<Container> current = Optional.empty();
        Container containerParent = menu.getParent();
        boolean bl = iterate = containerParent != null;
        if (!iterate) {
            current = Optional.of(menu);
        }
        while (iterate) {
            if (containerParent instanceof JPopupMenu) {
                JPopupMenu popupMenu = (JPopupMenu)containerParent;
                Component invoker = popupMenu.getInvoker();
                if (invoker instanceof JMenu) {
                    containerParent = (JMenu)invoker;
                    current = Optional.of(containerParent);
                }
            } else {
                if (containerParent instanceof JMenuBar) {
                    current = Optional.of(containerParent);
                    break;
                }
                if (containerParent instanceof JToolBar) {
                    current = Optional.of(containerParent);
                    break;
                }
            }
            if (containerParent.getParent() != null) {
                containerParent = containerParent.getParent();
                continue;
            }
            iterate = false;
        }
        return current;
    }

    public static Optional<Class<?>> getRootType(@NonNull JMenuItem menu) {
        boolean iterate;
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        Container containerParent = menu.getParent();
        boolean bl = iterate = containerParent != null;
        if (!iterate) {
            return Optional.of(JMenuItem.class);
        }
        return ParentMenuResolver.getCurrentRootType(containerParent);
    }

    private static Optional<Class<?>> getCurrentRootType(Container containerParent) {
        Optional<Class<Object>> current = Optional.empty();
        boolean iterate = true;
        while (iterate) {
            if (containerParent instanceof JPopupMenu) {
                JPopupMenu popupMenu = (JPopupMenu)containerParent;
                Component invoker = popupMenu.getInvoker();
                if (invoker instanceof JMenu) {
                    containerParent = (JMenu)invoker;
                    current = Optional.of(JMenu.class);
                }
            } else {
                if (containerParent instanceof JMenuBar) {
                    current = Optional.of(JMenuBar.class);
                    break;
                }
                if (containerParent instanceof JToolBar) {
                    current = Optional.of(JToolBar.class);
                    break;
                }
            }
            if (containerParent.getParent() != null) {
                containerParent = containerParent.getParent();
                continue;
            }
            iterate = false;
        }
        return current;
    }

    public static Optional<Class<?>> getRootType(@NonNull JMenu menu) {
        boolean hasNoParent;
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        Container containerParent = menu.getParent();
        boolean bl = hasNoParent = containerParent == null;
        if (hasNoParent) {
            return Optional.of(JMenu.class);
        }
        return ParentMenuResolver.getCurrentRootType(containerParent);
    }

    public static Optional<Class<?>> getParentType(@NonNull JMenu menu) {
        JPopupMenu popupMenu;
        Component invoker;
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        Container containerParent = menu.getParent();
        if (containerParent instanceof JPopupMenu && (invoker = (popupMenu = (JPopupMenu)containerParent).getInvoker()) instanceof JMenu) {
            return Optional.of(JMenu.class);
        }
        if (containerParent instanceof JMenuBar) {
            return Optional.of(JMenuBar.class);
        }
        if (containerParent instanceof JToolBar) {
            return Optional.of(JToolBar.class);
        }
        return Optional.empty();
    }

    public static Optional<JMenu> getParentMenu(@NonNull JMenuItem menu) {
        JPopupMenu popupMenu;
        Component invoker;
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        Container containerParent = menu.getParent();
        if (containerParent instanceof JPopupMenu && (invoker = (popupMenu = (JPopupMenu)containerParent).getInvoker()) instanceof JMenu) {
            return Optional.of((JMenu)invoker);
        }
        return Optional.empty();
    }
}

