/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.menu.factory;

import io.github.astrapi69.gen.tree.BaseTreeNode;
import io.github.astrapi69.swing.menu.enumeration.BaseMenuId;
import io.github.astrapi69.swing.menu.factory.MenuVisitorExtensions;
import io.github.astrapi69.swing.menu.model.MenuInfo;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import lombok.NonNull;

public class JMenuBarFactory {
    public static JMenuBar newJMenuBar() {
        return new JMenuBar();
    }

    public static JMenuBar buildMenuBar(@NonNull BaseTreeNode<MenuInfo, Long> root, @NonNull Map<String, ActionListener> actionListenerMap) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (actionListenerMap == null) {
            throw new NullPointerException("actionListenerMap is marked non-null but is null");
        }
        LinkedHashMap<String, JMenu> menuMap = new LinkedHashMap<String, JMenu>();
        LinkedHashMap<String, JMenuItem> menuItemMap = new LinkedHashMap<String, JMenuItem>();
        LinkedHashMap<String, JMenuBar> menuBarMap = new LinkedHashMap<String, JMenuBar>();
        MenuVisitorExtensions.visitAndAddToMap(root, actionListenerMap, menuMap, menuItemMap, menuBarMap);
        root.accept(menuInfoLongBaseTreeNode -> MenuVisitorExtensions.visitAndAddToMap((BaseTreeNode<MenuInfo, Long>)menuInfoLongBaseTreeNode, actionListenerMap, menuMap, menuItemMap, menuBarMap));
        root.accept(menuInfoLongBaseTreeNode -> MenuVisitorExtensions.visitAndAddToMenu((BaseTreeNode<MenuInfo, Long>)menuInfoLongBaseTreeNode, menuMap, menuItemMap, menuBarMap));
        return (JMenuBar)menuBarMap.get(BaseMenuId.MENU_BAR.propertiesKey());
    }
}

