/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.menu.factory;

import io.github.astrapi69.gen.tree.BaseTreeNode;
import io.github.astrapi69.swing.menu.MenuExtensions;
import io.github.astrapi69.swing.menu.factory.MenuVisitorExtensions;
import io.github.astrapi69.swing.menu.model.MenuInfo;
import io.github.astrapi69.swing.menu.model.MenuItemInfo;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import lombok.NonNull;

public class JMenuFactory {
    public static JMenu buildMenu(@NonNull BaseTreeNode<MenuInfo, Long> root, @NonNull Map<String, ActionListener> actionListenerMap) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (actionListenerMap == null) {
            throw new NullPointerException("actionListenerMap is marked non-null but is null");
        }
        HashMap<String, JMenu> menuMap = new HashMap<String, JMenu>();
        HashMap<String, JMenuItem> menuItemMap = new HashMap<String, JMenuItem>();
        HashMap<String, JMenuBar> menuBarMap = new HashMap<String, JMenuBar>();
        MenuVisitorExtensions.visitAndAddToMap(root, actionListenerMap, menuMap, menuItemMap, menuBarMap);
        root.accept(menuInfoLongBaseTreeNode -> MenuVisitorExtensions.visitAndAddToMap((BaseTreeNode<MenuInfo, Long>)menuInfoLongBaseTreeNode, actionListenerMap, menuMap, menuItemMap, menuBarMap));
        root.accept(menuInfoLongBaseTreeNode -> MenuVisitorExtensions.visitAndAddToMenu((BaseTreeNode<MenuInfo, Long>)menuInfoLongBaseTreeNode, menuMap, menuItemMap, menuBarMap));
        return (JMenu)menuMap.get(((MenuInfo)root.getValue()).getName());
    }

    public static JMenu newJMenu(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).build()).toJMenu();
    }

    public static JMenu newJMenu(@NonNull MenuItemInfo menuItemInfo) {
        if (menuItemInfo == null) {
            throw new NullPointerException("menuItemInfo is marked non-null but is null");
        }
        return menuItemInfo.toJMenu();
    }

    public static JMenu newJMenu(@NonNull String text, int mnemonic) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).mnemonic(mnemonic)).build()).toJMenu();
    }

    public static JMenu newJMenu(@NonNull String text, int mnemonic, @NonNull ActionListener actionListener) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (actionListener == null) {
            throw new NullPointerException("actionListener is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).mnemonic(mnemonic)).actionListener(actionListener)).build()).toJMenu();
    }

    public static JMenu newJMenu(@NonNull String text, char mnemonic) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).mnemonic(MenuExtensions.toMnemonic(mnemonic))).build()).toJMenu();
    }

    public static JMenu newJMenu(@NonNull String text, char mnemonic, @NonNull ActionListener actionListener) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (actionListener == null) {
            throw new NullPointerException("actionListener is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).mnemonic(MenuExtensions.toMnemonic(mnemonic))).actionListener(actionListener)).build()).toJMenu();
    }
}

