/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.menu.factory;

import io.github.astrapi69.swing.menu.MenuExtensions;
import io.github.astrapi69.swing.menu.model.MenuItemInfo;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import lombok.NonNull;

public class JMenuItemFactory {
    public static JMenuItem newJMenuItem(@NonNull MenuItemInfo menuItemInfo) {
        if (menuItemInfo == null) {
            throw new NullPointerException("menuItemInfo is marked non-null but is null");
        }
        return menuItemInfo.toJMenuItem();
    }

    public static JMenuItem newJMenuItem(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).build()).toJMenuItem();
    }

    public static JMenuItem newJMenuItem(@NonNull String text, @NonNull ActionListener actionListener) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (actionListener == null) {
            throw new NullPointerException("actionListener is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).actionListener(actionListener)).build()).toJMenuItem();
    }

    public static JMenuItem newJMenuItem(@NonNull String text, int mnemonic) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).mnemonic(mnemonic)).build()).toJMenuItem();
    }

    public static JMenuItem newJMenuItem(@NonNull String text, int mnemonic, char accelerator) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).mnemonic(mnemonic)).keyStroke(KeyStroke.getKeyStroke((int)accelerator, 128))).build()).toJMenuItem();
    }

    public static JMenuItem newJMenuItem(@NonNull String text, int mnemonic, char accelerator, @NonNull ActionListener actionListener) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (actionListener == null) {
            throw new NullPointerException("actionListener is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).mnemonic(mnemonic)).keyStroke(KeyStroke.getKeyStroke((int)accelerator, 128))).actionListener(actionListener)).build()).toJMenuItem();
    }

    public static JMenuItem newJMenuItem(@NonNull String text, int mnemonic, KeyStroke keyStroke, @NonNull ActionListener actionListener) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (actionListener == null) {
            throw new NullPointerException("actionListener is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).mnemonic(mnemonic)).keyStroke(keyStroke)).actionListener(actionListener)).build()).toJMenuItem();
    }

    public static JMenuItem newJMenuItem(@NonNull String text, int mnemonic, KeyStroke keyStroke, ActionListener actionListener, String name) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).mnemonic(mnemonic)).keyStroke(keyStroke)).actionListener(actionListener)).name(name)).build()).toJMenuItem();
    }

    public static JMenuItem newJMenuItem(@NonNull String text, char mnemonic, char accelerator) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).mnemonic(MenuExtensions.toMnemonic(mnemonic))).keyStroke(KeyStroke.getKeyStroke((int)accelerator, 128))).build()).toJMenuItem();
    }

    public static JMenuItem newJMenuItem(@NonNull String text, char mnemonic, char accelerator, @NonNull ActionListener actionListener) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (actionListener == null) {
            throw new NullPointerException("actionListener is marked non-null but is null");
        }
        return ((MenuItemInfo)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)((MenuItemInfo.MenuItemInfoBuilder)MenuItemInfo.builder().text(text)).mnemonic(MenuExtensions.toMnemonic(mnemonic))).keyStroke(KeyStroke.getKeyStroke((int)accelerator, 128))).actionListener(actionListener)).build()).toJMenuItem();
    }
}

