/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.menu.factory;

import io.github.astrapi69.collection.list.ListExtensions;
import io.github.astrapi69.collection.list.ListFactory;
import io.github.astrapi69.gen.tree.BaseTreeNode;
import io.github.astrapi69.swing.menu.ParentMenuResolver;
import io.github.astrapi69.swing.menu.enumeration.MenuType;
import io.github.astrapi69.swing.menu.model.MenuInfo;
import io.github.astrapi69.swing.menu.model.MenuItemInfo;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuElement;
import lombok.NonNull;

public class MenuVisitorExtensions {
    public static void visitAndAddToMenu(@NonNull BaseTreeNode<MenuInfo, Long> menuInfoLongBaseTreeNode, @NonNull Map<String, JMenu> menuMap, @NonNull Map<String, JMenuItem> menuItemMap, @NonNull Map<String, JMenuBar> menuBarMap) {
        if (menuInfoLongBaseTreeNode == null) {
            throw new NullPointerException("menuInfoLongBaseTreeNode is marked non-null but is null");
        }
        if (menuMap == null) {
            throw new NullPointerException("menuMap is marked non-null but is null");
        }
        if (menuItemMap == null) {
            throw new NullPointerException("menuItemMap is marked non-null but is null");
        }
        if (menuBarMap == null) {
            throw new NullPointerException("menuBarMap is marked non-null but is null");
        }
        MenuInfo menuInfo = (MenuInfo)menuInfoLongBaseTreeNode.getValue();
        MenuType menuType = menuInfo.getType();
        String actionId = menuInfo.getName();
        BaseTreeNode parent = menuInfoLongBaseTreeNode.getParent();
        switch (menuType) {
            case MENU_ITEM: {
                JMenuItem menuItem = menuItemMap.get(actionId);
                MenuVisitorExtensions.addToMenu(menuMap, (BaseTreeNode<MenuInfo, Long>)parent, menuItem);
                break;
            }
            case CHECK_BOX_MENU_ITEM: {
                JCheckBoxMenuItem checkBoxMenuItem = (JCheckBoxMenuItem)menuItemMap.get(actionId);
                MenuVisitorExtensions.addToMenu(menuMap, (BaseTreeNode<MenuInfo, Long>)parent, checkBoxMenuItem);
                break;
            }
            case RADIO_BUTTON_MENU_ITEM: {
                JRadioButtonMenuItem radioButtonMenuItem = (JRadioButtonMenuItem)menuItemMap.get(actionId);
                MenuVisitorExtensions.addToMenu(menuMap, (BaseTreeNode<MenuInfo, Long>)parent, radioButtonMenuItem);
                break;
            }
            case MENU: {
                JMenu menu = menuMap.get(actionId);
                if (parent != null && menuBarMap.containsKey(((MenuInfo)parent.getValue()).getName())) {
                    JMenuBar menuBar = menuBarMap.get(((MenuInfo)parent.getValue()).getName());
                    int length = menuBar.getSubElements().length;
                    if (0 < length) {
                        int indexOf = MenuVisitorExtensions.getSortedList((BaseTreeNode<MenuInfo, Long>)parent).indexOf(menuInfoLongBaseTreeNode);
                        menuBar.add((Component)menu, indexOf);
                    } else {
                        menuBar.add(menu);
                    }
                }
                MenuVisitorExtensions.addToMenu(menuMap, (BaseTreeNode<MenuInfo, Long>)parent, menu);
            }
        }
    }

    private static void addToMenu(Map<String, JMenu> menuMap, BaseTreeNode<MenuInfo, Long> parent, JMenuItem menuItem) {
        if (parent != null && menuMap.containsKey(((MenuInfo)parent.getValue()).getName())) {
            JMenu parentMenu = menuMap.get(((MenuInfo)parent.getValue()).getName());
            List<MenuElement> childMenuElements = ParentMenuResolver.getChildMenuElements(parentMenu);
            List<BaseTreeNode<MenuInfo, Long>> sortedList = MenuVisitorExtensions.getSortedList(parent);
            List sortedMenuNames = ListFactory.newArrayList((Object[])new String[0]);
            List newSortedMenuNames = ListFactory.newArrayList((Object[])new String[0]);
            for (BaseTreeNode<MenuInfo, Long> btn : sortedList) {
                sortedMenuNames.add(((MenuInfo)btn.getValue()).getName());
            }
            for (MenuElement me : childMenuElements) {
                newSortedMenuNames.add(me.getComponent().getName());
            }
            int indexToInsert = ListExtensions.getIndexToInsert((List)sortedMenuNames, (List)newSortedMenuNames, (Object)menuItem.getName());
            parentMenu.insert(menuItem, indexToInsert);
        }
    }

    private static List<BaseTreeNode<MenuInfo, Long>> getSortedList(BaseTreeNode<MenuInfo, Long> parent) {
        Collection children = parent.getChildren();
        ArrayList<BaseTreeNode<MenuInfo, Long>> list = new ArrayList<BaseTreeNode<MenuInfo, Long>>(children);
        Collections.sort(list, Comparator.comparing(BaseTreeNode::getId));
        return list;
    }

    public static void visitAndAddToMap(@NonNull BaseTreeNode<MenuInfo, Long> menuInfoLongBaseTreeNode, @NonNull Map<String, ActionListener> actionListenerMap, @NonNull Map<String, JMenu> menuMap, @NonNull Map<String, JMenuItem> menuItemMap, @NonNull Map<String, JMenuBar> menuBarMap) {
        if (menuInfoLongBaseTreeNode == null) {
            throw new NullPointerException("menuInfoLongBaseTreeNode is marked non-null but is null");
        }
        if (actionListenerMap == null) {
            throw new NullPointerException("actionListenerMap is marked non-null but is null");
        }
        if (menuMap == null) {
            throw new NullPointerException("menuMap is marked non-null but is null");
        }
        if (menuItemMap == null) {
            throw new NullPointerException("menuItemMap is marked non-null but is null");
        }
        if (menuBarMap == null) {
            throw new NullPointerException("menuBarMap is marked non-null but is null");
        }
        MenuInfo menuInfo = (MenuInfo)menuInfoLongBaseTreeNode.getValue();
        if (actionListenerMap.containsKey(menuInfo.getName())) {
            MenuItemInfo menuItemInfo = menuInfo.toMenuItemInfo(actionListenerMap.get(menuInfo.getName()));
            actionListenerMap.remove(menuInfo.getName());
            MenuType menuType = menuInfo.getType();
            switch (menuType) {
                case MENU_BAR: {
                    JMenuBar menuBar = menuItemInfo.toJMenuBar();
                    menuBarMap.put(menuInfo.getName(), menuBar);
                    break;
                }
                case MENU_ITEM: {
                    JMenuItem menuItem = menuItemInfo.toJMenuItem();
                    menuItemMap.put(menuInfo.getName(), menuItem);
                    break;
                }
                case RADIO_BUTTON_MENU_ITEM: {
                    JRadioButtonMenuItem radioButtonMenuItem = menuItemInfo.toJRadioButtonMenuItem();
                    menuItemMap.put(menuInfo.getName(), radioButtonMenuItem);
                    break;
                }
                case CHECK_BOX_MENU_ITEM: {
                    JCheckBoxMenuItem checkBoxMenuItem = menuItemInfo.toJCheckBoxMenuItem();
                    menuItemMap.put(menuInfo.getName(), checkBoxMenuItem);
                    break;
                }
                case MENU: {
                    JMenu menu = menuItemInfo.toJMenu();
                    menuMap.put(menuInfo.getName(), menu);
                }
            }
        }
    }
}

