/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.menu.model;

import javax.swing.KeyStroke;
import lombok.NonNull;

public class KeyStrokeInfo {
    private Character keyChar;
    private Integer keyCode;
    private Integer modifiers;
    private Boolean onKeyRelease;
    private String keystrokeAsString;

    public static KeyStrokeInfo toKeyStrokeInfo(@NonNull KeyStroke keyStroke) {
        if (keyStroke == null) {
            throw new NullPointerException("keyStroke is marked non-null but is null");
        }
        return ((KeyStrokeInfoBuilder)((KeyStrokeInfoBuilder)((KeyStrokeInfoBuilder)((KeyStrokeInfoBuilder)((KeyStrokeInfoBuilder)KeyStrokeInfo.builder().keyCode(keyStroke.getKeyCode())).keyChar(Character.valueOf(keyStroke.getKeyChar()))).modifiers(keyStroke.getModifiers())).onKeyRelease(keyStroke.isOnKeyRelease())).keystrokeAsString(keyStroke.toString())).build();
    }

    public void set(@NonNull KeyStroke keyStroke) {
        if (keyStroke == null) {
            throw new NullPointerException("keyStroke is marked non-null but is null");
        }
        this.keyCode = keyStroke.getKeyCode();
        this.keyChar = Character.valueOf(keyStroke.getKeyChar());
        this.modifiers = keyStroke.getModifiers();
        this.onKeyRelease = keyStroke.isOnKeyRelease();
        this.keystrokeAsString = keyStroke.toString();
    }

    public KeyStroke toKeyStroke() {
        KeyStroke keyStroke = null;
        if (this.keystrokeAsString != null && !this.keystrokeAsString.isEmpty() && (keyStroke = KeyStroke.getKeyStroke(this.keystrokeAsString)) != null) {
            return keyStroke;
        }
        if (this.keyCode != null) {
            if (this.onKeyRelease != null && this.modifiers != null && (keyStroke = KeyStroke.getKeyStroke(this.keyCode, this.modifiers, this.onKeyRelease)) != null) {
                return keyStroke;
            }
            if (this.modifiers != null && (keyStroke = KeyStroke.getKeyStroke(this.keyCode, (int)this.modifiers)) != null) {
                return keyStroke;
            }
        }
        if (this.keyChar != null) {
            if (this.modifiers != null && (keyStroke = KeyStroke.getKeyStroke(this.keyChar, (int)this.modifiers)) != null) {
                return keyStroke;
            }
            keyStroke = KeyStroke.getKeyStroke(this.keyChar.charValue());
            if (keyStroke != null) {
                return keyStroke;
            }
        }
        return keyStroke;
    }

    protected KeyStrokeInfo(KeyStrokeInfoBuilder<?, ?> b) {
        this.keyChar = b.keyChar;
        this.keyCode = b.keyCode;
        this.modifiers = b.modifiers;
        this.onKeyRelease = b.onKeyRelease;
        this.keystrokeAsString = b.keystrokeAsString;
    }

    public static KeyStrokeInfoBuilder<?, ?> builder() {
        return new KeyStrokeInfoBuilderImpl();
    }

    public KeyStrokeInfoBuilder<?, ?> toBuilder() {
        return new KeyStrokeInfoBuilderImpl().$fillValuesFrom(this);
    }

    public Character getKeyChar() {
        return this.keyChar;
    }

    public Integer getKeyCode() {
        return this.keyCode;
    }

    public Integer getModifiers() {
        return this.modifiers;
    }

    public Boolean getOnKeyRelease() {
        return this.onKeyRelease;
    }

    public String getKeystrokeAsString() {
        return this.keystrokeAsString;
    }

    public void setKeyChar(Character keyChar) {
        this.keyChar = keyChar;
    }

    public void setKeyCode(Integer keyCode) {
        this.keyCode = keyCode;
    }

    public void setModifiers(Integer modifiers) {
        this.modifiers = modifiers;
    }

    public void setOnKeyRelease(Boolean onKeyRelease) {
        this.onKeyRelease = onKeyRelease;
    }

    public void setKeystrokeAsString(String keystrokeAsString) {
        this.keystrokeAsString = keystrokeAsString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyStrokeInfo)) {
            return false;
        }
        KeyStrokeInfo other = (KeyStrokeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Character this$keyChar = this.getKeyChar();
        Character other$keyChar = other.getKeyChar();
        if (this$keyChar == null ? other$keyChar != null : !((Object)this$keyChar).equals(other$keyChar)) {
            return false;
        }
        Integer this$keyCode = this.getKeyCode();
        Integer other$keyCode = other.getKeyCode();
        if (this$keyCode == null ? other$keyCode != null : !((Object)this$keyCode).equals(other$keyCode)) {
            return false;
        }
        Integer this$modifiers = this.getModifiers();
        Integer other$modifiers = other.getModifiers();
        if (this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers)) {
            return false;
        }
        Boolean this$onKeyRelease = this.getOnKeyRelease();
        Boolean other$onKeyRelease = other.getOnKeyRelease();
        if (this$onKeyRelease == null ? other$onKeyRelease != null : !((Object)this$onKeyRelease).equals(other$onKeyRelease)) {
            return false;
        }
        String this$keystrokeAsString = this.getKeystrokeAsString();
        String other$keystrokeAsString = other.getKeystrokeAsString();
        return !(this$keystrokeAsString == null ? other$keystrokeAsString != null : !this$keystrokeAsString.equals(other$keystrokeAsString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyStrokeInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Character $keyChar = this.getKeyChar();
        result = result * 59 + ($keyChar == null ? 43 : ((Object)$keyChar).hashCode());
        Integer $keyCode = this.getKeyCode();
        result = result * 59 + ($keyCode == null ? 43 : ((Object)$keyCode).hashCode());
        Integer $modifiers = this.getModifiers();
        result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
        Boolean $onKeyRelease = this.getOnKeyRelease();
        result = result * 59 + ($onKeyRelease == null ? 43 : ((Object)$onKeyRelease).hashCode());
        String $keystrokeAsString = this.getKeystrokeAsString();
        result = result * 59 + ($keystrokeAsString == null ? 43 : $keystrokeAsString.hashCode());
        return result;
    }

    public String toString() {
        return "KeyStrokeInfo(keyChar=" + this.getKeyChar() + ", keyCode=" + this.getKeyCode() + ", modifiers=" + this.getModifiers() + ", onKeyRelease=" + this.getOnKeyRelease() + ", keystrokeAsString=" + this.getKeystrokeAsString() + ")";
    }

    public KeyStrokeInfo() {
    }

    public KeyStrokeInfo(Character keyChar, Integer keyCode, Integer modifiers, Boolean onKeyRelease, String keystrokeAsString) {
        this.keyChar = keyChar;
        this.keyCode = keyCode;
        this.modifiers = modifiers;
        this.onKeyRelease = onKeyRelease;
        this.keystrokeAsString = keystrokeAsString;
    }

    private static final class KeyStrokeInfoBuilderImpl
    extends KeyStrokeInfoBuilder<KeyStrokeInfo, KeyStrokeInfoBuilderImpl> {
        private KeyStrokeInfoBuilderImpl() {
        }

        @Override
        protected KeyStrokeInfoBuilderImpl self() {
            return this;
        }

        @Override
        public KeyStrokeInfo build() {
            return new KeyStrokeInfo(this);
        }
    }

    public static abstract class KeyStrokeInfoBuilder<C extends KeyStrokeInfo, B extends KeyStrokeInfoBuilder<C, B>> {
        private Character keyChar;
        private Integer keyCode;
        private Integer modifiers;
        private Boolean onKeyRelease;
        private String keystrokeAsString;

        protected B $fillValuesFrom(C instance) {
            KeyStrokeInfoBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(KeyStrokeInfo instance, KeyStrokeInfoBuilder<?, ?> b) {
            b.keyChar(instance.keyChar);
            b.keyCode(instance.keyCode);
            b.modifiers(instance.modifiers);
            b.onKeyRelease(instance.onKeyRelease);
            b.keystrokeAsString(instance.keystrokeAsString);
        }

        protected abstract B self();

        public abstract C build();

        public B keyChar(Character keyChar) {
            this.keyChar = keyChar;
            return this.self();
        }

        public B keyCode(Integer keyCode) {
            this.keyCode = keyCode;
            return this.self();
        }

        public B modifiers(Integer modifiers) {
            this.modifiers = modifiers;
            return this.self();
        }

        public B onKeyRelease(Boolean onKeyRelease) {
            this.onKeyRelease = onKeyRelease;
            return this.self();
        }

        public B keystrokeAsString(String keystrokeAsString) {
            this.keystrokeAsString = keystrokeAsString;
            return this.self();
        }

        public String toString() {
            return "KeyStrokeInfo.KeyStrokeInfoBuilder(keyChar=" + this.keyChar + ", keyCode=" + this.keyCode + ", modifiers=" + this.modifiers + ", onKeyRelease=" + this.onKeyRelease + ", keystrokeAsString=" + this.keystrokeAsString + ")";
        }
    }
}

