/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.menu.model;

import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class MenuItemInfo {
    private final String text;
    private final String actionCommand;
    private final Integer mnemonic;
    private final KeyStroke keyStroke;
    private final ActionListener actionListener;
    private final String name;

    public JCheckBoxMenuItem toJCheckBoxMenuItem() {
        JCheckBoxMenuItem jMenuItem = new JCheckBoxMenuItem();
        this.setFields(jMenuItem);
        if (this.keyStroke != null) {
            jMenuItem.setAccelerator(this.keyStroke);
        }
        return jMenuItem;
    }

    public JRadioButtonMenuItem toJRadioButtonMenuItem() {
        JRadioButtonMenuItem jMenuItem = new JRadioButtonMenuItem();
        this.setFields(jMenuItem);
        if (this.keyStroke != null) {
            jMenuItem.setAccelerator(this.keyStroke);
        }
        return jMenuItem;
    }

    public JMenuItem toJMenuItem() {
        JMenuItem jMenuItem = new JMenuItem();
        this.setFields(jMenuItem);
        if (this.keyStroke != null) {
            jMenuItem.setAccelerator(this.keyStroke);
        }
        return jMenuItem;
    }

    public MenuItem toMenuItem() {
        MenuItem menuItem = new MenuItem();
        if (this.text != null) {
            menuItem.setLabel(this.text);
        }
        if (this.mnemonic != null) {
            menuItem.setShortcut(new MenuShortcut(this.mnemonic));
        }
        if (this.actionListener != null) {
            menuItem.addActionListener(this.actionListener);
        }
        if (this.name != null) {
            menuItem.setName(this.name);
        }
        if (this.actionCommand != null) {
            menuItem.setActionCommand(this.actionCommand);
        }
        return menuItem;
    }

    public JMenu toJMenu() {
        JMenu jMenu = new JMenu();
        this.setFields(jMenu);
        return jMenu;
    }

    public JMenuBar toJMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        if (this.name != null) {
            menuBar.setName(this.name);
        }
        return menuBar;
    }

    private void setFields(JMenuItem menuItem) {
        if (this.text != null) {
            menuItem.setText(this.text);
        }
        if (this.mnemonic != null) {
            menuItem.setMnemonic(this.mnemonic);
        }
        if (this.actionListener != null) {
            menuItem.addActionListener(this.actionListener);
        }
        if (this.name != null) {
            menuItem.setName(this.name);
        }
        if (this.actionCommand != null) {
            menuItem.setActionCommand(this.actionCommand);
        }
    }

    protected MenuItemInfo(MenuItemInfoBuilder<?, ?> b) {
        this.text = b.text;
        this.actionCommand = b.actionCommand;
        this.mnemonic = b.mnemonic;
        this.keyStroke = b.keyStroke;
        this.actionListener = b.actionListener;
        this.name = b.name;
    }

    public static MenuItemInfoBuilder<?, ?> builder() {
        return new MenuItemInfoBuilderImpl();
    }

    public String getText() {
        return this.text;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public Integer getMnemonic() {
        return this.mnemonic;
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MenuItemInfo)) {
            return false;
        }
        MenuItemInfo other = (MenuItemInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$mnemonic = this.getMnemonic();
        Integer other$mnemonic = other.getMnemonic();
        if (this$mnemonic == null ? other$mnemonic != null : !((Object)this$mnemonic).equals(other$mnemonic)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$actionCommand = this.getActionCommand();
        String other$actionCommand = other.getActionCommand();
        if (this$actionCommand == null ? other$actionCommand != null : !this$actionCommand.equals(other$actionCommand)) {
            return false;
        }
        KeyStroke this$keyStroke = this.getKeyStroke();
        KeyStroke other$keyStroke = other.getKeyStroke();
        if (this$keyStroke == null ? other$keyStroke != null : !((Object)this$keyStroke).equals(other$keyStroke)) {
            return false;
        }
        ActionListener this$actionListener = this.getActionListener();
        ActionListener other$actionListener = other.getActionListener();
        if (this$actionListener == null ? other$actionListener != null : !this$actionListener.equals(other$actionListener)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MenuItemInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $mnemonic = this.getMnemonic();
        result = result * 59 + ($mnemonic == null ? 43 : ((Object)$mnemonic).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $actionCommand = this.getActionCommand();
        result = result * 59 + ($actionCommand == null ? 43 : $actionCommand.hashCode());
        KeyStroke $keyStroke = this.getKeyStroke();
        result = result * 59 + ($keyStroke == null ? 43 : ((Object)$keyStroke).hashCode());
        ActionListener $actionListener = this.getActionListener();
        result = result * 59 + ($actionListener == null ? 43 : $actionListener.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "MenuItemInfo(text=" + this.getText() + ", actionCommand=" + this.getActionCommand() + ", mnemonic=" + this.getMnemonic() + ", keyStroke=" + this.getKeyStroke() + ", actionListener=" + this.getActionListener() + ", name=" + this.getName() + ")";
    }

    private static final class MenuItemInfoBuilderImpl
    extends MenuItemInfoBuilder<MenuItemInfo, MenuItemInfoBuilderImpl> {
        private MenuItemInfoBuilderImpl() {
        }

        @Override
        protected MenuItemInfoBuilderImpl self() {
            return this;
        }

        @Override
        public MenuItemInfo build() {
            return new MenuItemInfo(this);
        }
    }

    public static abstract class MenuItemInfoBuilder<C extends MenuItemInfo, B extends MenuItemInfoBuilder<C, B>> {
        private String text;
        private String actionCommand;
        private Integer mnemonic;
        private KeyStroke keyStroke;
        private ActionListener actionListener;
        private String name;

        protected abstract B self();

        public abstract C build();

        public B text(String text) {
            this.text = text;
            return this.self();
        }

        public B actionCommand(String actionCommand) {
            this.actionCommand = actionCommand;
            return this.self();
        }

        public B mnemonic(Integer mnemonic) {
            this.mnemonic = mnemonic;
            return this.self();
        }

        public B keyStroke(KeyStroke keyStroke) {
            this.keyStroke = keyStroke;
            return this.self();
        }

        public B actionListener(ActionListener actionListener) {
            this.actionListener = actionListener;
            return this.self();
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public String toString() {
            return "MenuItemInfo.MenuItemInfoBuilder(text=" + this.text + ", actionCommand=" + this.actionCommand + ", mnemonic=" + this.mnemonic + ", keyStroke=" + this.keyStroke + ", actionListener=" + this.actionListener + ", name=" + this.name + ")";
        }
    }
}

