/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.menu.model.transform;

import io.github.astrapi69.gen.tree.BaseTreeNode;
import io.github.astrapi69.gen.tree.convert.BaseTreeNodeTransformer;
import io.github.astrapi69.swing.menu.enumeration.BaseMenuId;
import io.github.astrapi69.swing.menu.enumeration.MenuType;
import io.github.astrapi69.swing.menu.model.KeyStrokeInfo;
import io.github.astrapi69.swing.menu.model.MenuInfo;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import io.github.astrapi69.xstream.ObjectToXmlExtensions;
import io.github.astrapi69.xstream.XmlToObjectExtensions;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import lombok.NonNull;

public class MenuInfoTreeNodeConverter {
    public static BaseTreeNode<MenuInfo, Long> toMenuInfoTreeNode(@NonNull String xml) {
        if (xml == null) {
            throw new NullPointerException("xml is marked non-null but is null");
        }
        Map treeIdNodeMap = (Map)RuntimeExceptionDecorator.decorate(() -> (Map)XmlToObjectExtensions.toObject((String)xml));
        return BaseTreeNodeTransformer.getRoot((Map)treeIdNodeMap);
    }

    public static String toXml(@NonNull BaseTreeNode<MenuInfo, Long> root) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        Map treeIdNodeMap = BaseTreeNodeTransformer.toKeyMap(root);
        String xml = (String)RuntimeExceptionDecorator.decorate(() -> ObjectToXmlExtensions.toXml((Object)treeIdNodeMap));
        return xml;
    }

    public static MenuInfo fromJMenuBar() {
        return ((MenuInfo.MenuInfoBuilder)((MenuInfo.MenuInfoBuilder)MenuInfo.builder().type(MenuType.MENU_BAR)).name(BaseMenuId.MENU_BAR.propertiesKey())).build();
    }

    public static MenuInfo fromJMenu(@NonNull JMenu menu) {
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        return menu.getAccelerator() != null ? ((MenuInfo.MenuInfoBuilder)((MenuInfo.MenuInfoBuilder)((MenuInfo.MenuInfoBuilder)((MenuInfo.MenuInfoBuilder)((MenuInfo.MenuInfoBuilder)MenuInfo.builder().type(MenuType.MENU)).name(menu.getName())).text(menu.getText())).mnemonic(menu.getMnemonic())).keyStrokeInfo(KeyStrokeInfo.toKeyStrokeInfo(menu.getAccelerator()))).build() : ((MenuInfo.MenuInfoBuilder)((MenuInfo.MenuInfoBuilder)((MenuInfo.MenuInfoBuilder)((MenuInfo.MenuInfoBuilder)MenuInfo.builder().type(MenuType.MENU)).name(menu.getName())).text(menu.getText())).mnemonic(menu.getMnemonic())).build();
    }

    public static MenuInfo fromJMenuItem(@NonNull JMenuItem menu) {
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        return ((MenuInfo.MenuInfoBuilder)((MenuInfo.MenuInfoBuilder)((MenuInfo.MenuInfoBuilder)((MenuInfo.MenuInfoBuilder)((MenuInfo.MenuInfoBuilder)MenuInfo.builder().type(MenuType.MENU_ITEM)).name(menu.getName())).text(menu.getText())).mnemonic(menu.getMnemonic())).keyStrokeInfo(KeyStrokeInfo.toKeyStrokeInfo(menu.getAccelerator()))).build();
    }
}

