/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.swing.plaf.action;

import io.github.astrapi69.swing.plaf.LookAndFeels;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.UnsupportedLookAndFeelException;

public class LookAndFeelAction
extends AbstractAction {
    private static final Logger log = Logger.getLogger(LookAndFeelAction.class.getName());
    private static final long serialVersionUID = 1L;
    private final Component component;
    private final LookAndFeels lookAndFeel;

    public LookAndFeelAction(String name, Component component, LookAndFeels lookAndFeel) {
        super(name);
        this.component = component;
        this.lookAndFeel = lookAndFeel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.onChangeOfLookAndFeel(event);
    }

    protected void onChangeOfLookAndFeel(ActionEvent event) {
        try {
            LookAndFeels.setLookAndFeel(this.lookAndFeel, this.component);
        }
        catch (UnsupportedLookAndFeelException e) {
            log.log(Level.INFO, "Look and Feel not supported " + this.lookAndFeel.getLookAndFeelName(), e);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.INFO, "Look and Feel class not found " + this.lookAndFeel.getLookAndFeelName(), e);
        }
        catch (InstantiationException e) {
            log.log(Level.INFO, "Look and Feel could not instantiated " + this.lookAndFeel.getLookAndFeelName(), e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.INFO, "Illegal access exception is thrown for the Look and Feel " + this.lookAndFeel.getLookAndFeelName(), e);
        }
    }

    protected Component getComponent() {
        return this.component;
    }

    protected LookAndFeels getLookAndFeel() {
        return this.lookAndFeel;
    }
}

