/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.model;

import io.github.astrapi69.model.api.Attachable;
import io.github.astrapi69.model.api.IChainingModel;
import io.github.astrapi69.model.api.IDetachable;
import io.github.astrapi69.model.api.IModel;

public class ChainingModel<T>
implements IChainingModel<T> {
    private static final long serialVersionUID = 1L;
    private Object target;

    public ChainingModel(Object target) {
        this.target = target;
    }

    @Override
    public void attach() {
        if (this.target instanceof Attachable) {
            ((Attachable)this.target).attach();
        }
    }

    @Override
    public void detach() {
        if (this.target instanceof IDetachable) {
            ((IDetachable)this.target).detach();
        }
    }

    @Override
    public IModel<?> getChainedModel() {
        if (this.target instanceof IModel) {
            return (IModel)this.target;
        }
        return null;
    }

    @Override
    public void setChainedModel(IModel<?> model) {
        this.target = model;
    }

    @Override
    public T getObject() {
        if (this.target instanceof IModel) {
            return ((IModel)this.target).getObject();
        }
        return (T)this.target;
    }

    @Override
    public void setObject(T object) {
        if (this.target instanceof IModel) {
            ((IModel)this.target).setObject(object);
        } else {
            this.target = object;
        }
    }

    protected final Object getTarget() {
        return this.target;
    }

    protected final ChainingModel<T> setTarget(Object modelObject) {
        this.target = modelObject;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IModel:classname=[");
        sb.append(this.getClass().getName()).append(']');
        sb.append(":nestedModel=[").append(this.target).append(']');
        return sb.toString();
    }
}

