/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.model;

import io.github.astrapi69.model.api.Attachable;
import io.github.astrapi69.model.api.IDetachable;
import io.github.astrapi69.model.api.IModel;
import io.github.astrapi69.model.api.IObjectClassAwareModel;
import io.github.astrapi69.model.util.MapModel;
import io.github.astrapi69.model.util.WildcardCollectionModel;
import io.github.astrapi69.model.util.WildcardListModel;
import io.github.astrapi69.model.util.WildcardSetModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GenericModel<T>
implements IModel<T>,
IObjectClassAwareModel<T> {
    private static final long serialVersionUID = 1L;
    private T object;

    public GenericModel(T object) {
        this.setObject(object);
    }

    public static <C> IModel<Collection<C>> ofCollection(Collection<C> collection) {
        return new WildcardCollectionModel<C>(collection);
    }

    public static <C> IModel<List<C>> ofList(List<C> list) {
        return WildcardListModel.of(list);
    }

    public static <K, V> IModel<Map<K, V>> ofMap(Map<K, V> map) {
        return MapModel.ofMap(map);
    }

    public static <C> IModel<Set<C>> ofSet(Set<C> set) {
        return WildcardSetModel.ofSet(set);
    }

    @Override
    public void attach() {
        if (this.object instanceof Attachable) {
            ((Attachable)this.object).attach();
        }
    }

    @Override
    public void detach() {
        if (this.object instanceof IDetachable) {
            ((IDetachable)this.object).detach();
        }
    }

    @Override
    public Class<T> getObjectClass() {
        return this.object != null ? this.object.getClass() : null;
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public void setObject(T object) {
        this.object = object;
    }

    public String toString() {
        return "GenericModel(object=" + this.getObject() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericModel)) {
            return false;
        }
        GenericModel other = (GenericModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$object = this.getObject();
        T other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public GenericModel() {
    }
}

