/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.model;

import io.github.astrapi69.model.api.IModel;
import io.github.astrapi69.model.api.SerializableBiConsumer;
import io.github.astrapi69.model.api.SerializableFunction;

public abstract class LambdaBindingModel<T>
implements IModel<T> {
    private static final long serialVersionUID = 1L;

    private LambdaBindingModel() {
    }

    public static <X, T> IModel<T> of(final IModel<X> source, final IModel<X> target, final SerializableFunction<X, T> getter, final SerializableBiConsumer<X, T> setter) {
        return new LambdaBindingModel<T>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void attach() {
                source.attach();
                target.attach();
            }

            @Override
            public void detach() {
                source.detach();
                target.detach();
            }

            @Override
            public T getObject() {
                Object sourceObject = source.getObject();
                if (sourceObject == null) {
                    return null;
                }
                return getter.apply(sourceObject);
            }

            @Override
            public void setObject(T t) {
                Object targetObject;
                Object sourceObject = source.getObject();
                if (sourceObject != null) {
                    setter.accept(sourceObject, t);
                }
                if ((targetObject = target.getObject()) != null) {
                    setter.accept(targetObject, t);
                }
            }
        };
    }

    public static <X, Y, T> IModel<T> of(final IModel<X> source, final IModel<Y> target, final SerializableFunction<X, T> sourceGetter, final SerializableBiConsumer<X, T> sourceSetter, final SerializableFunction<Y, T> targetGetter, final SerializableBiConsumer<Y, T> targetSetter) {
        return new LambdaBindingModel<T>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void attach() {
                source.attach();
                target.attach();
            }

            @Override
            public void detach() {
                source.detach();
                target.detach();
            }

            @Override
            public T getObject() {
                Object sourceObject = source.getObject();
                Object targetObject = target.getObject();
                if (sourceObject == null && targetObject == null) {
                    return null;
                }
                if (sourceObject != null && targetObject != null) {
                    Object sourceApply = sourceGetter.apply(sourceObject);
                    Object targetApply = targetGetter.apply(targetObject);
                    if (sourceApply != null && !sourceApply.equals(targetApply)) {
                        targetSetter.accept(targetObject, sourceApply);
                    }
                }
                return sourceGetter.apply(sourceObject);
            }

            @Override
            public void setObject(T t) {
                Object targetObject;
                Object sourceObject = source.getObject();
                if (sourceObject != null) {
                    sourceSetter.accept(sourceObject, t);
                }
                if ((targetObject = target.getObject()) != null) {
                    targetSetter.accept(targetObject, t);
                }
            }
        };
    }

    @Override
    public void setObject(T t) {
        throw new UnsupportedOperationException("setObject(Object) not supported");
    }
}

