/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.model;

import io.github.astrapi69.model.api.IModel;
import io.github.astrapi69.model.api.SerializableBiConsumer;
import io.github.astrapi69.model.api.SerializableConsumer;
import io.github.astrapi69.model.api.SerializableFunction;
import io.github.astrapi69.model.api.SerializableSupplier;

public class SimpleLambdaModel<T>
implements IModel<T> {
    private final SerializableSupplier<T> getter;
    private final SerializableConsumer<T> setter;

    public static <T> IModel<T> of(SerializableSupplier<T> getter, SerializableConsumer<T> setter) {
        return new SimpleLambdaModel<T>(getter, setter);
    }

    public static <X, T> IModel<T> of(final IModel<X> target, final SerializableFunction<X, T> getter) {
        return new SimpleLambdaModel<T>(null, null){
            private static final long serialVersionUID = 1L;

            @Override
            public void attach() {
                target.attach();
            }

            @Override
            public void detach() {
                target.detach();
            }

            @Override
            public T getObject() {
                Object x = target.getObject();
                if (x == null) {
                    return null;
                }
                return getter.apply(x);
            }

            @Override
            public void setObject(T t) {
                throw new UnsupportedOperationException("setObject(Object) not supported");
            }
        };
    }

    public static <X, T> IModel<T> of(final IModel<X> target, final SerializableFunction<X, T> getter, final SerializableBiConsumer<X, T> setter) {
        return new SimpleLambdaModel<T>(null, null){
            private static final long serialVersionUID = 1L;

            @Override
            public void attach() {
                target.attach();
            }

            @Override
            public void detach() {
                target.detach();
            }

            @Override
            public T getObject() {
                Object x = target.getObject();
                if (x == null) {
                    return null;
                }
                return getter.apply(x);
            }

            @Override
            public void setObject(T t) {
                Object x = target.getObject();
                if (x != null) {
                    setter.accept(x, t);
                }
            }
        };
    }

    @Override
    public void attach() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void detach() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public T getObject() {
        try {
            return this.getter.get();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public void setObject(T object) {
        try {
            this.setter.accept(object);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Set property to a null object is not supported", e);
        }
    }

    public SimpleLambdaModel(SerializableSupplier<T> getter, SerializableConsumer<T> setter) {
        this.getter = getter;
        this.setter = setter;
    }
}

