/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.model.property;

import io.github.astrapi69.model.property.AbstractGetAndSet;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ArrayGetSet
extends AbstractGetAndSet {
    private static final Logger log = Logger.getLogger(ArrayGetSet.class.getName());
    private final Class<?> clzComponentType;
    private final int index;

    ArrayGetSet(Class<?> clzComponentType, int index) {
        this.clzComponentType = clzComponentType;
        this.index = index;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.clzComponentType;
    }

    @Override
    public Object getValue(Object object) {
        if (Array.getLength(object) > this.index) {
            return Array.get(object, this.index);
        }
        return null;
    }

    @Override
    public Object newValue(Object object) {
        Object value = null;
        try {
            value = this.clzComponentType.newInstance();
            Array.set(object, this.index, value);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot set new value " + value + " at index " + this.index + " for array holding elements of class " + this.clzComponentType, e);
        }
        return value;
    }

    @Override
    public void setValue(Object object, Object value) {
        Array.set(object, this.index, value);
    }
}

