/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.model.property;

import io.github.astrapi69.model.property.AbstractGetAndSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ArrayPropertyGetSet
extends AbstractGetAndSet {
    private static final Logger log = Logger.getLogger(ArrayPropertyGetSet.class.getName());
    private final Method getMethod;
    private final Integer index;
    private Method setMethod;

    ArrayPropertyGetSet(Method method, int index) {
        this.index = index;
        this.getMethod = method;
        this.getMethod.setAccessible(true);
    }

    private static final Method findSetter(Method getMethod, Class<?> clz) {
        Object name = getMethod.getName();
        name = "set" + ((String)name).substring(3);
        try {
            return clz.getMethod((String)name, Integer.TYPE, getMethod.getReturnType());
        }
        catch (Exception e) {
            log.log(Level.FINE, "Can't find setter method corresponding to " + getMethod);
            return null;
        }
    }

    @Override
    public Class<?> getTargetClass() {
        return this.getMethod.getReturnType();
    }

    @Override
    public Object getValue(Object object) {
        Object ret = null;
        try {
            ret = this.getMethod.invoke(object, this.index);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Error calling index property method: " + this.getMethod + " on object: " + object, ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error calling index property method: " + this.getMethod + " on object: " + object, ex);
        }
        return ret;
    }

    @Override
    public Object newValue(Object object) {
        if (this.setMethod == null) {
            this.setMethod = ArrayPropertyGetSet.findSetter(this.getMethod, object.getClass());
        }
        if (this.setMethod == null) {
            log.log(Level.WARNING, "Null setMethod");
            return null;
        }
        Class<?> clz = this.getMethod.getReturnType();
        Object value = null;
        try {
            value = clz.newInstance();
            this.setMethod.invoke(object, this.index, value);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot set new value " + value + " at index " + this.index, e);
        }
        return value;
    }

    @Override
    public void setValue(Object object, Object value) {
        if (this.setMethod == null) {
            this.setMethod = ArrayPropertyGetSet.findSetter(this.getMethod, object.getClass());
        }
        if (this.setMethod != null) {
            this.setMethod.setAccessible(true);
            try {
                this.setMethod.invoke(object, this.index, value);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Error index property calling method: " + this.setMethod + " on object: " + object, ex.getCause());
            }
            catch (Exception ex) {
                throw new RuntimeException("Error index property calling method: " + this.setMethod + " on object: " + object, ex);
            }
        } else {
            throw new RuntimeException("No set method defined for value: " + value + " on object: " + object);
        }
    }
}

