/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.model.property;

import io.github.astrapi69.model.property.AbstractGetAndSet;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldGetAndSetter
extends AbstractGetAndSet {
    private static final Logger log = Logger.getLogger(FieldGetAndSetter.class.getName());
    private final Field field;

    public FieldGetAndSetter(Field field) {
        this.field = field;
        this.field.setAccessible(true);
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.field.getType();
    }

    @Override
    public Object getValue(Object object) {
        try {
            return this.field.get(object);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error getting field value of field " + this.field + " from object " + object, ex);
        }
    }

    @Override
    public Object newValue(Object object) {
        Class<?> clz = this.field.getType();
        Object value = null;
        try {
            value = clz.newInstance();
            this.field.set(object, value);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot set field " + this.field + " to " + value, e);
        }
        return value;
    }

    @Override
    public void setValue(Object object, Object value) {
        try {
            this.field.set(object, value);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error setting field value of field " + this.field + " on object " + object + ", value " + value, ex);
        }
    }
}

