/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.model.property;

import io.github.astrapi69.model.property.AbstractGetAndSet;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MethodGetAndSet
extends AbstractGetAndSet {
    private static final Logger log = Logger.getLogger(MethodGetAndSet.class.getName());
    private final Field field;
    private final Method getMethod;
    private final Method setMethod;

    MethodGetAndSet(Method getMethod, Method setMethod, Field field) {
        this.getMethod = getMethod;
        this.getMethod.setAccessible(true);
        this.field = field;
        this.setMethod = setMethod;
    }

    public static final Method findSetter(Method getMethod, Class<?> clz) {
        Object name = getMethod.getName();
        name = ((String)name).startsWith("get") ? "set" + ((String)name).substring(3) : "set" + ((String)name).substring(2);
        try {
            Method method = clz.getMethod((String)name, getMethod.getReturnType());
            if (method != null) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            Method[] methods;
            for (Method method : methods = clz.getMethods()) {
                Class<?>[] parameterTypes;
                if (!method.getName().equals(name) || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(getMethod.getReturnType())) continue;
                return method;
            }
            log.log(Level.FINE, "Cannot find setter corresponding to " + getMethod);
        }
        catch (Exception e) {
            log.log(Level.FINE, "Cannot find setter corresponding to " + getMethod);
        }
        return null;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Method getGetter() {
        return this.getMethod;
    }

    @Override
    public Method getSetter() {
        return this.setMethod;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.getMethod.getReturnType();
    }

    @Override
    public final Object getValue(Object object) {
        Object ret = null;
        try {
            ret = this.getMethod.invoke(object, (Object[])null);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Error calling method: " + this.getMethod + " on object: " + object, ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error calling method: " + this.getMethod + " on object: " + object, ex);
        }
        return ret;
    }

    @Override
    public Object newValue(Object object) {
        if (this.setMethod == null) {
            log.log(Level.WARNING, "Null setMethod");
            return null;
        }
        Class<?> clz = this.getMethod.getReturnType();
        Object value = null;
        try {
            value = clz.newInstance();
            this.setMethod.invoke(object, value);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot set new value " + value, e);
        }
        return value;
    }

    @Override
    public final void setValue(Object object, Object value) {
        Object converted = value;
        if (this.setMethod != null) {
            try {
                this.setMethod.invoke(object, converted);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Error calling method: " + this.setMethod + " on object: " + object, ex.getCause());
            }
            catch (Exception ex) {
                throw new RuntimeException("Error calling method: " + this.setMethod + " on object: " + object, ex);
            }
        } else if (this.field != null) {
            try {
                this.field.set(object, converted);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error setting field: " + this.field + " on object: " + object, ex);
            }
        } else {
            throw new RuntimeException("no set method defined for value: " + value + " on object: " + object + " while respective getMethod being " + this.getMethod.getName());
        }
    }
}

