/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.model.property;

import io.github.astrapi69.model.api.ClassCache;
import io.github.astrapi69.model.api.GetAndSet;
import io.github.astrapi69.model.property.ArrayGetSet;
import io.github.astrapi69.model.property.ArrayLengthGetSet;
import io.github.astrapi69.model.property.ArrayPropertyGetSet;
import io.github.astrapi69.model.property.FieldGetAndSetter;
import io.github.astrapi69.model.property.ListGetSet;
import io.github.astrapi69.model.property.MapGetSet;
import io.github.astrapi69.model.property.MethodGetAndSet;
import io.github.astrapi69.model.property.ObjectAndGetSetter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public final class PropertyResolver {
    private static final Logger log = Logger.getLogger(PropertyResolver.class.getName());
    private static final ConcurrentHashMap<Object, ClassCache> applicationToClassesToGetAndSetters = new ConcurrentHashMap(2);
    private static final int CREATE_NEW_VALUE = 1;
    private static final String GET = "get";
    private static final String IS = "is";
    private static final int RESOLVE_CLASS = 2;
    private static final int RETURN_NULL = 0;

    private PropertyResolver() {
    }

    public static void destroy(Object application) {
        applicationToClassesToGetAndSetters.remove(application);
    }

    private static Field findField(Class<?> clz, String expression) {
        Field field = null;
        try {
            field = clz.getField(expression);
        }
        catch (Exception e) {
            for (Class<?> tmp = clz; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
                Field[] fields;
                for (Field aField : fields = tmp.getDeclaredFields()) {
                    if (!aField.getName().equals(expression)) continue;
                    aField.setAccessible(true);
                    return aField;
                }
            }
            log.log(Level.FINE, "Cannot find field " + clz + "." + expression);
        }
        return field;
    }

    private static final Method findGetter(Class<?> clz, String expression) {
        String name = Character.toUpperCase(expression.charAt(0)) + expression.substring(1);
        Method method = null;
        try {
            method = clz.getMethod(GET + name, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = clz.getMethod(IS + name, null);
            }
            catch (Exception e) {
                log.log(Level.FINE, "Cannot find getter " + clz + "." + expression);
            }
        }
        return method;
    }

    private static final Method findMethod(Class<?> clz, String expression) {
        if (expression.endsWith("()")) {
            expression = expression.substring(0, expression.length() - 2);
        }
        Method method = null;
        try {
            method = clz.getMethod(expression, null);
        }
        catch (Exception e) {
            log.log(Level.FINE, "Cannot find method " + clz + "." + expression);
        }
        return method;
    }

    private static ClassCache getClassesToGetAndSetters() {
        ClassCache tmpResult;
        Class<PropertyResolver> key = PropertyResolver.class;
        ClassCache result = applicationToClassesToGetAndSetters.get(key);
        if (result == null && (tmpResult = applicationToClassesToGetAndSetters.putIfAbsent(key, result = new DefaultClassCache())) != null) {
            result = tmpResult;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final GetAndSet getGetAndSetter(String exp, Class<?> clz) {
        GetAndSet getAndSetter;
        ClassCache classesToGetAndSetters = PropertyResolver.getClassesToGetAndSetters();
        Map<String, GetAndSet> getAndSetters = classesToGetAndSetters.get(clz);
        if (getAndSetters == null) {
            getAndSetters = new ConcurrentHashMap<String, GetAndSet>(8);
            classesToGetAndSetters.put(clz, getAndSetters);
        }
        if ((getAndSetter = getAndSetters.get(exp)) != null) return getAndSetter;
        Method method = null;
        Field field = null;
        if (exp.startsWith("[")) {
            exp = exp.substring(1, exp.length() - 1);
        } else {
            method = exp.endsWith("()") ? PropertyResolver.findMethod(clz, exp) : PropertyResolver.findGetter(clz, exp);
        }
        if (method == null) {
            if (List.class.isAssignableFrom(clz)) {
                try {
                    int index = Integer.parseInt(exp);
                    getAndSetter = new ListGetSet(index);
                }
                catch (NumberFormatException ex) {
                    method = PropertyResolver.findMethod(clz, exp);
                    if (method != null) {
                        getAndSetter = new MethodGetAndSet(method, MethodGetAndSet.findSetter(method, clz), null);
                    }
                    field = PropertyResolver.findField(clz, exp);
                    if (field == null) throw new RuntimeException("The expression '" + exp + "' is neither an index nor is it a method or field for the list " + clz);
                    getAndSetter = new FieldGetAndSetter(field);
                }
            } else if (Map.class.isAssignableFrom(clz)) {
                getAndSetter = new MapGetSet(exp);
            } else if (clz.isArray()) {
                try {
                    int index = Integer.parseInt(exp);
                    getAndSetter = new ArrayGetSet(clz.getComponentType(), index);
                }
                catch (NumberFormatException ex) {
                    if (!exp.equals("length") && !exp.equals("size")) throw new RuntimeException("Can't parse the expression '" + exp + "' as an index for an array lookup");
                    getAndSetter = new ArrayLengthGetSet();
                }
            } else {
                field = PropertyResolver.findField(clz, exp);
                if (field == null) {
                    method = PropertyResolver.findMethod(clz, exp);
                    if (method == null) {
                        int index = exp.indexOf(46);
                        if (index == -1) throw new RuntimeException("No get method defined for class: " + clz + " expression: " + exp);
                        String propertyName = exp.substring(0, index);
                        String propertyIndex = exp.substring(index + 1);
                        try {
                            int parsedIndex = Integer.parseInt(propertyIndex);
                            String name = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                            method = clz.getMethod(GET + name, Integer.TYPE);
                            getAndSetter = new ArrayPropertyGetSet(method, parsedIndex);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("No get method defined for class: " + clz + " expression: " + propertyName);
                        }
                    } else {
                        getAndSetter = new MethodGetAndSet(method, MethodGetAndSet.findSetter(method, clz), null);
                    }
                } else {
                    getAndSetter = new FieldGetAndSetter(field);
                }
            }
        } else {
            field = PropertyResolver.findField(clz, exp);
            getAndSetter = new MethodGetAndSet(method, MethodGetAndSet.findSetter(method, clz), field);
        }
        getAndSetters.put(exp, getAndSetter);
        return getAndSetter;
    }

    private static int getNextDotIndex(String expression, int start) {
        boolean insideBracket = false;
        for (int i = start; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            if (ch == '.' && !insideBracket) {
                return i;
            }
            if (ch == '[') {
                insideBracket = true;
                continue;
            }
            if (ch != ']') continue;
            insideBracket = false;
        }
        return -1;
    }

    private static ObjectAndGetSetter getObjectAndGetSetter(String expression, Object object, int tryToCreateNull) {
        return PropertyResolver.getObjectAndGetSetter(expression, object, tryToCreateNull, object.getClass());
    }

    private static ObjectAndGetSetter getObjectAndGetSetter(String expression, Object object, int tryToCreateNull, Class<?> clz) {
        GetAndSet getAndSetter;
        String expressionBracketsSeperated = PropertyResolver.replaceAll(expression, "[", ".[").toString();
        int index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, 0);
        while (index == 0 && expressionBracketsSeperated.startsWith(".")) {
            expressionBracketsSeperated = expressionBracketsSeperated.substring(1);
            index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, 0);
        }
        int lastIndex = 0;
        Object value = object;
        String exp = expressionBracketsSeperated;
        while (index != -1) {
            exp = expressionBracketsSeperated.substring(lastIndex, index);
            if (exp.length() == 0) {
                exp = expressionBracketsSeperated.substring(index + 1);
                break;
            }
            getAndSetter = null;
            try {
                getAndSetter = PropertyResolver.getGetAndSetter(exp, clz);
            }
            catch (RuntimeException ex) {
                index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, index + 1);
                if (index == -1) {
                    exp = expressionBracketsSeperated.substring(lastIndex);
                    break;
                }
                String indexExpression = expressionBracketsSeperated.substring(lastIndex, index);
                getAndSetter = PropertyResolver.getGetAndSetter(indexExpression, clz);
            }
            Object newValue = null;
            if (value != null) {
                newValue = getAndSetter.getValue(value);
            }
            if (newValue == null) {
                if (tryToCreateNull == 1) {
                    newValue = getAndSetter.newValue(value);
                    if (newValue == null) {
                        return null;
                    }
                } else if (tryToCreateNull == 2) {
                    clz = getAndSetter.getTargetClass();
                } else {
                    return null;
                }
            }
            if ((value = newValue) != null) {
                clz = value.getClass();
            }
            if ((index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, lastIndex = index + 1)) != -1) continue;
            exp = expressionBracketsSeperated.substring(lastIndex);
            break;
        }
        getAndSetter = PropertyResolver.getGetAndSetter(exp, clz);
        return new ObjectAndGetSetter(getAndSetter, value);
    }

    public static <T> Class<T> getPropertyClass(String expression, Class<?> clz) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, null, 2, clz);
        if (setter == null) {
            throw new RuntimeException("No Class returned for expression: " + expression + " for getting the target class of: " + clz);
        }
        return setter.getTargetClass();
    }

    public static final Class<?> getPropertyClass(String expression, Object object) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 2);
        if (setter == null) {
            throw new RuntimeException("Null object returned for expression: " + expression + " for getting the target class of: " + object);
        }
        return setter.getTargetClass();
    }

    public static final Field getPropertyField(String expression, Object object) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 2);
        if (setter == null) {
            throw new RuntimeException("Null object returned for expression: " + expression + " for getting the target class of: " + object);
        }
        return setter.getField();
    }

    public static final Method getPropertyGetter(String expression, Object object) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 2);
        if (setter == null) {
            throw new RuntimeException("Null object returned for expression: " + expression + " for getting the target class of: " + object);
        }
        return setter.getGetter();
    }

    public static final Method getPropertySetter(String expression, Object object) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 2);
        if (setter == null) {
            throw new RuntimeException("Null object returned for expression: " + expression + " for getting the target class of: " + object);
        }
        return setter.getSetter();
    }

    public static final Object getValue(String expression, Object object) {
        if (expression == null || expression.equals("") || object == null) {
            return object;
        }
        ObjectAndGetSetter getter = PropertyResolver.getObjectAndGetSetter(expression, object, 0);
        if (getter == null) {
            return null;
        }
        return getter.getValue();
    }

    public static CharSequence replaceAll(CharSequence s, CharSequence searchFor, CharSequence replaceWith) {
        int searchForLength;
        String searchString;
        int matchIndex;
        if (s == null) {
            return null;
        }
        if (searchFor == null || "".equals(searchFor)) {
            return s;
        }
        if (replaceWith == null) {
            replaceWith = "";
        }
        if ((matchIndex = PropertyResolver.search(s, searchString = searchFor.toString(), 0)) == -1) {
            return s;
        }
        int size = s.length();
        int replaceWithLength = replaceWith.length();
        if (replaceWithLength > (searchForLength = searchFor.length())) {
            size += replaceWithLength - searchForLength;
        }
        StringBuilder buffer = new StringBuilder(size + 16);
        int pos = 0;
        do {
            buffer.append(s.subSequence(pos, matchIndex));
            buffer.append(replaceWith);
        } while ((matchIndex = PropertyResolver.search(s, searchString, pos = matchIndex + searchForLength)) != -1);
        buffer.append(s.subSequence(pos, s.length()));
        return buffer;
    }

    private static int search(CharSequence s, String searchString, int pos) {
        if (s instanceof String) {
            return ((String)s).indexOf(searchString, pos);
        }
        if (s instanceof StringBuffer) {
            return ((StringBuffer)s).indexOf(searchString, pos);
        }
        if (s instanceof StringBuilder) {
            return ((StringBuilder)s).indexOf(searchString, pos);
        }
        return s.toString().indexOf(searchString, pos);
    }

    public static void setClassCache(Object application, ClassCache classCache) {
        if (application != null) {
            applicationToClassesToGetAndSetters.put(application, classCache);
        } else {
            applicationToClassesToGetAndSetters.put(PropertyResolver.class, classCache);
        }
    }

    public static final void setValue(String expression, Object object, Object value) {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            throw new RuntimeException("Empty expression setting value: " + value + " on object: " + object);
        }
        if (object == null) {
            throw new RuntimeException("Attempted to set property value on a null object. Property expression: " + expression + " Value: " + value);
        }
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 1);
        if (setter == null) {
            throw new RuntimeException("Null object returned for expression: " + expression + " for setting value: " + value + " on: " + object);
        }
        setter.setValue(value);
    }

    private static class DefaultClassCache
    implements ClassCache {
        private final ConcurrentHashMap<Class<?>, Map<String, GetAndSet>> map = new ConcurrentHashMap(16);

        private DefaultClassCache() {
        }

        @Override
        public Map<String, GetAndSet> get(Class<?> clz) {
            return this.map.get(clz);
        }

        @Override
        public void put(Class<?> clz, Map<String, GetAndSet> values) {
            this.map.put(clz, values);
        }
    }
}

