/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.model.reflect;

import io.github.astrapi69.model.reflect.IMethodResolver;
import io.github.astrapi69.model.reflect.Reflection;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;

public class DefaultMethodResolver
implements IMethodResolver {
    @Override
    public Serializable getId(Method method) {
        String name = method.getName();
        StringBuilder id = new StringBuilder();
        if (Reflection.isGetter(method)) {
            if (name.startsWith("get")) {
                id.append(Character.toLowerCase(name.charAt(3)));
                id.append(name.substring(4));
                return id.toString();
            }
            if (name.startsWith("is")) {
                id.append(Character.toLowerCase(name.charAt(2)));
                id.append(name.substring(3));
                return id.toString();
            }
        }
        Class<?>[] parameters = method.getParameterTypes();
        id.append(method.getName());
        id.append("(");
        for (int p = 0; p < parameters.length; ++p) {
            String simpleName;
            if (p > 0) {
                id.append(",");
            }
            if (parameters[p].isArray()) {
                id.append("[");
            }
            if ((simpleName = parameters[p].getSimpleName()).isEmpty()) continue;
            id.append(simpleName.charAt(0));
        }
        id.append(")");
        return id.toString();
    }

    @Override
    public Method getMethod(Class<?> owner, Serializable id) {
        for (Class<?> candidate = owner; candidate != null; candidate = candidate.getSuperclass()) {
            for (Method method : candidate.getDeclaredMethods()) {
                if (!id.equals(this.getId(method))) continue;
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return method;
            }
        }
        throw new IllegalArgumentException(String.format("unknown method %s#%s", owner.getName(), id));
    }

    @Override
    public Method getSetter(Method getter) {
        Method setter;
        Object name = getter.getName();
        Class<?>[] getterParameters = getter.getParameterTypes();
        if (((String)name).equals("get") && Map.class.isAssignableFrom(getter.getDeclaringClass())) {
            name = "put";
        } else if (((String)name).startsWith("get")) {
            name = "set" + ((String)name).substring(3);
        } else if (((String)name).startsWith("is")) {
            name = "set" + ((String)name).substring(2);
        } else {
            throw new RuntimeException(String.format("no setter for %s#%s", getter.getClass(), name));
        }
        Class[] setterParameters = new Class[getterParameters.length + 1];
        System.arraycopy(getterParameters, 0, setterParameters, 0, getterParameters.length);
        setterParameters[getterParameters.length] = getter.getReturnType();
        Class<?> owner = getter.getDeclaringClass();
        while (true) {
            try {
                setter = owner.getDeclaredMethod((String)name, setterParameters);
            }
            catch (Exception e) {
                if (owner == Object.class) {
                    throw new RuntimeException(String.format("no setter for %s#%s", getter.getDeclaringClass(), name));
                }
                owner = owner.getSuperclass();
                continue;
            }
            break;
        }
        try {
            setter.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return setter;
    }
}

