/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.core;

import io.github.astrapi69.check.Check;
import io.github.astrapi69.crypt.api.Cryptor;
import io.github.astrapi69.crypt.api.algorithm.SunJCEAlgorithm;
import io.github.astrapi69.crypt.api.algorithm.compound.CompoundAlgorithm;
import io.github.astrapi69.crypt.data.factory.AlgorithmParameterSpecFactory;
import io.github.astrapi69.crypt.data.factory.CipherFactory;
import io.github.astrapi69.crypt.data.factory.KeySpecFactory;
import io.github.astrapi69.crypt.data.factory.SecretKeyFactoryExtensions;
import io.github.astrapi69.crypt.data.model.CryptModel;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractCryptor<C, K, T>
implements Serializable,
Cryptor {
    private static final long serialVersionUID = 1L;
    protected final CryptModel<C, K, T> model;

    public AbstractCryptor(CryptModel<C, K, T> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        Objects.requireNonNull(model);
        Check.get().notNull(model.getKey(), "model.getKey()");
        this.model = model;
        this.onInitialize();
    }

    public AbstractCryptor(K key) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this(CryptModel.builder().key(key).build());
    }

    public CryptModel<C, K, T> getModel() {
        return this.model;
    }

    protected String newAlgorithm() {
        if (this.model.getAlgorithm() == null) {
            return SunJCEAlgorithm.PBEWithMD5AndDES.getAlgorithm();
        }
        return this.model.getAlgorithm().getAlgorithm();
    }

    protected AlgorithmParameterSpec newAlgorithmParameterSpec(byte[] salt, int iterationCount) {
        return AlgorithmParameterSpecFactory.newPBEParameterSpec((byte[])salt, (int)iterationCount);
    }

    protected C newCipher(K key) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        return this.newCipher(key, this.newAlgorithm(), this.newSalt(), this.newIterationCount(), this.newOperationMode());
    }

    protected abstract C newCipher(K var1, String var2, byte[] var3, int var4, int var5) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException;

    protected int newIterationCount() {
        if (this.model.getIterationCount() == null) {
            return 19;
        }
        return this.model.getIterationCount();
    }

    protected byte[] newSalt() {
        if (ArrayUtils.isEmpty((byte[])this.getModel().getSalt())) {
            return CompoundAlgorithm.SALT;
        }
        return this.getModel().getSalt();
    }

    protected SecretKeyFactory newSecretKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        return SecretKeyFactoryExtensions.newSecretKeyFactory((String)algorithm);
    }

    protected void onInitialize() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        C cipher = this.newCipher(this.model.getKey());
        this.model.setCipher(cipher);
        this.model.setInitialized(true);
    }

    protected KeySpec newKeySpec(String password, byte[] salt, int iterationCount) {
        return KeySpecFactory.newPBEKeySpec((String)password, (byte[])salt, (int)iterationCount);
    }

    protected Cipher newCipher(int operationMode, SecretKey key, AlgorithmParameterSpec paramSpec, String alg) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return CipherFactory.newCipher((int)operationMode, (SecretKey)key, (AlgorithmParameterSpec)paramSpec, (String)alg);
    }

    protected Cipher newCipher(String password, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        return CipherFactory.newCipher((String)password, (String)algorithm, (byte[])salt, (int)iterationCount, (int)operationMode);
    }
}

