/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.core;

import io.github.astrapi69.crypt.api.Encryptor;

public abstract class ChainableEncryptor<T>
implements Encryptor<T, T> {
    private final Encryptor<T, T>[] encryptors;

    @SafeVarargs
    public ChainableEncryptor(Encryptor<T, T> ... encryptors) {
        this.encryptors = encryptors;
    }

    public T encrypt(T toEncrypt) throws Exception {
        Object result = toEncrypt;
        for (Encryptor<T, T> encryptor : this.encryptors) {
            result = encryptor.encrypt(result);
        }
        return result;
    }

    public Encryptor<T, T>[] getEncryptors() {
        return this.encryptors;
    }
}

