/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.decorator;

import io.github.astrapi69.crypt.data.model.CryptObjectDecorator;
import io.github.astrapi69.file.read.ReadFileExtensions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class CryptObjectDecoratorExtensions {
    private CryptObjectDecoratorExtensions() {
    }

    public static String decorateFile(File toEncrypt, CryptObjectDecorator<String> decorator) throws IOException {
        Objects.requireNonNull(toEncrypt);
        Objects.requireNonNull(decorator);
        return CryptObjectDecoratorExtensions.decorateWithStringDecorator(ReadFileExtensions.fromFile((File)toEncrypt), decorator);
    }

    public static String decorateWithBytearrayDecorator(String toEncrypt, CryptObjectDecorator<byte[]> decorator, Charset charset) {
        Objects.requireNonNull(toEncrypt);
        Objects.requireNonNull(decorator);
        Objects.requireNonNull(charset);
        StringBuilder sb = new StringBuilder();
        sb.append(new String((byte[])decorator.getPrefix(), charset));
        sb.append(toEncrypt);
        sb.append(new String((byte[])decorator.getSuffix(), charset));
        return sb.toString();
    }

    public static String decorateWithCharacterDecorator(String toEncrypt, CryptObjectDecorator<Character> decorator) {
        Objects.requireNonNull(toEncrypt);
        Objects.requireNonNull(decorator);
        StringBuilder sb = new StringBuilder();
        sb.append(decorator.getPrefix());
        sb.append(toEncrypt);
        sb.append(decorator.getSuffix());
        return sb.toString();
    }

    public static String decorateWithStringDecorator(String toEncrypt, CryptObjectDecorator<String> decorator) {
        Objects.requireNonNull(toEncrypt);
        Objects.requireNonNull(decorator);
        StringBuilder sb = new StringBuilder();
        sb.append((String)decorator.getPrefix());
        sb.append(toEncrypt);
        sb.append((String)decorator.getSuffix());
        return sb.toString();
    }

    private static boolean endsWith(byte[] array, byte[] suffix) {
        int lastIndex;
        Objects.requireNonNull(array);
        Objects.requireNonNull(suffix);
        int currentIndex = lastIndex = suffix.length - 1;
        if (ArrayUtils.isEmpty((byte[])suffix)) {
            return false;
        }
        for (int i = array.length - 1; 0 <= i; --i) {
            if (suffix[currentIndex--] != array[i]) {
                return false;
            }
            if (currentIndex == -1) break;
        }
        return true;
    }

    private static byte[] removeFromEnd(byte[] array, byte[] suffix) {
        Objects.requireNonNull(array);
        Objects.requireNonNull(suffix);
        return Arrays.copyOf(array, array.length - suffix.length);
    }

    private static byte[] removeFromStart(byte[] array, byte[] prefix) {
        Objects.requireNonNull(array);
        Objects.requireNonNull(prefix);
        byte[] result = new byte[array.length - prefix.length];
        System.arraycopy(array, prefix.length, result, 0, result.length);
        return result;
    }

    private static boolean startsWith(byte[] array, byte[] prefix) {
        for (int i = 0; i < prefix.length; ++i) {
            if (prefix[i] == array[i]) continue;
            return false;
        }
        return true;
    }

    public static String undecorateFile(File decrypted, CryptObjectDecorator<String> decorator) throws IOException {
        Objects.requireNonNull(decrypted);
        Objects.requireNonNull(decorator);
        return CryptObjectDecoratorExtensions.undecorateWithStringDecorator(ReadFileExtensions.fromFile((File)decrypted), decorator);
    }

    public static String undecorateWithBytearrayDecorator(String toEncrypt, CryptObjectDecorator<byte[]> decorator) {
        Objects.requireNonNull(toEncrypt);
        Objects.requireNonNull(decorator);
        byte[] result = toEncrypt.getBytes();
        byte[] prefix = (byte[])decorator.getPrefix();
        byte[] suffix = (byte[])decorator.getSuffix();
        result = ArrayUtils.removeElements((byte[])result, (byte[])prefix);
        if (CryptObjectDecoratorExtensions.startsWith(result, prefix)) {
            result = CryptObjectDecoratorExtensions.removeFromStart(result, prefix);
        }
        if (CryptObjectDecoratorExtensions.endsWith(result, suffix)) {
            result = CryptObjectDecoratorExtensions.removeFromEnd(result, suffix);
        }
        return new String(result);
    }

    public static String undecorateWithCharacterDecorator(String toEncrypt, CryptObjectDecorator<Character> decorator) {
        Objects.requireNonNull(toEncrypt);
        Objects.requireNonNull(decorator);
        StringBuilder sb = new StringBuilder(toEncrypt);
        boolean prefixRemoved = false;
        if (toEncrypt.startsWith(((Character)decorator.getPrefix()).toString())) {
            sb.deleteCharAt(0);
            prefixRemoved = true;
        }
        if (toEncrypt.endsWith(((Character)decorator.getSuffix()).toString())) {
            if (prefixRemoved) {
                sb.deleteCharAt(toEncrypt.length() - 2);
            } else {
                sb.deleteCharAt(toEncrypt.length() - 1);
            }
        }
        return sb.toString();
    }

    public static String undecorateWithStringDecorator(String decrypted, CryptObjectDecorator<String> decorator) {
        Objects.requireNonNull(decrypted);
        Objects.requireNonNull(decorator);
        String result = decrypted;
        if (decrypted.startsWith((String)decorator.getPrefix())) {
            result = StringUtils.removeStart((String)result, (String)((String)decorator.getPrefix()));
        }
        if (decrypted.endsWith((String)decorator.getSuffix())) {
            result = StringUtils.removeEnd((String)result, (String)((String)decorator.getSuffix()));
        }
        return result;
    }
}

