/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.file;

import io.github.astrapi69.crypt.data.model.CryptModel;
import io.github.astrapi69.crypt.data.model.CryptObjectDecorator;
import io.github.astrapi69.file.read.ReadFileExtensions;
import io.github.astrapi69.file.write.StoreFileExtensions;
import io.github.astrapi69.mystic.crypt.core.AbstractFileDecryptor;
import io.github.astrapi69.mystic.crypt.decorator.CryptObjectDecoratorExtensions;
import io.github.astrapi69.mystic.crypt.io.CryptoCipherOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FilenameUtils;

public class FileDecryptor
extends AbstractFileDecryptor {
    private static final long serialVersionUID = 1L;
    private File decryptedFile;

    public FileDecryptor(CryptModel<Cipher, String, String> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
    }

    public FileDecryptor(CryptModel<Cipher, String, String> model, File decryptedFile) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
        this.decryptedFile = decryptedFile;
    }

    public File decrypt(File encrypted) throws Exception {
        Objects.requireNonNull(encrypted);
        this.onBeforeDecrypt(encrypted);
        this.onDecrypt(encrypted);
        this.onAfterDecrypt(encrypted);
        return this.decryptedFile;
    }

    protected File newDecryptedFile(String parent, String child) {
        return new File(parent, child);
    }

    protected void onAfterDecrypt(File encrypted) throws IOException {
        Objects.requireNonNull(encrypted);
        List decorators = this.getModel().getDecorators();
        if (decorators != null && !decorators.isEmpty()) {
            String decryptedFileString = ReadFileExtensions.fromFile((File)this.decryptedFile);
            for (int i = decorators.size() - 1; 0 <= i; --i) {
                decryptedFileString = CryptObjectDecoratorExtensions.undecorateFile(this.decryptedFile, (CryptObjectDecorator<String>)((CryptObjectDecorator)decorators.get(i)));
            }
            StoreFileExtensions.toFile((File)this.decryptedFile, (String)decryptedFileString, (String)Charset.forName("UTF-8").name());
        }
    }

    protected void onBeforeDecrypt(File encrypted) {
        Objects.requireNonNull(encrypted);
        if (this.decryptedFile == null) {
            String filename = FilenameUtils.getBaseName((String)encrypted.getName());
            this.decryptedFile = this.newDecryptedFile(encrypted.getParent(), filename + ".decrypted");
        }
    }

    protected void onDecrypt(File encrypted) throws Exception {
        Objects.requireNonNull(encrypted);
        try (FileOutputStream decryptedOut = new FileOutputStream(this.decryptedFile);
             CryptoCipherOutputStream cos = new CryptoCipherOutputStream(decryptedOut, (Cipher)this.getModel().getCipher());
             FileInputStream fileInputStream = new FileInputStream(encrypted);){
            int c;
            while ((c = ((InputStream)fileInputStream).read()) != -1) {
                cos.write(c);
            }
        }
    }
}

