/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.file;

import io.github.astrapi69.crypt.data.factory.CipherFactory;
import io.github.astrapi69.crypt.data.model.CryptModel;
import io.github.astrapi69.crypt.data.model.CryptObjectDecorator;
import io.github.astrapi69.mystic.crypt.core.AbstractFileEncryptor;
import io.github.astrapi69.mystic.crypt.decorator.CryptObjectDecoratorExtensions;
import io.github.astrapi69.mystic.crypt.io.CryptoCipherInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FilenameUtils;

public class FileEncryptor
extends AbstractFileEncryptor {
    private static final long serialVersionUID = 1L;
    private File encryptedFile;

    public FileEncryptor(CryptModel<Cipher, String, String> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this(model, null);
    }

    @Override
    public byte[] encrypt(byte[] toEncrypt) throws Exception {
        throw new UnsupportedOperationException("");
    }

    @Override
    protected Cipher newCipher(String key, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        return CipherFactory.newCipher((String)key, (String)algorithm, (byte[])salt, (int)iterationCount, (int)operationMode);
    }

    public FileEncryptor(CryptModel<Cipher, String, String> model, File encryptedFile) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
        this.encryptedFile = encryptedFile;
    }

    public File encrypt(File toEncrypt) throws Exception {
        List decorators;
        if (this.encryptedFile == null) {
            String filename = FilenameUtils.getBaseName((String)toEncrypt.getName());
            this.encryptedFile = this.newEncryptedFile(toEncrypt.getParent(), filename + ".enc");
        }
        if ((decorators = this.getModel().getDecorators()) != null && !decorators.isEmpty()) {
            for (int i = 0; i < decorators.size(); ++i) {
                CryptObjectDecoratorExtensions.decorateFile(toEncrypt, (CryptObjectDecorator<String>)((CryptObjectDecorator)decorators.get(i)));
            }
        }
        try (CryptoCipherInputStream cis = new CryptoCipherInputStream(new FileInputStream(toEncrypt), (Cipher)this.getModel().getCipher());
             FileOutputStream out = new FileOutputStream(this.encryptedFile);){
            int c;
            while ((c = cis.read()) != -1) {
                ((OutputStream)out).write(c);
            }
        }
        return this.encryptedFile;
    }

    protected File newEncryptedFile(String parent, String child) {
        return new File(parent, child);
    }
}

