/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.file;

import io.github.astrapi69.crypt.data.model.CryptModel;
import io.github.astrapi69.mystic.crypt.core.AbstractObjectDecryptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;

public class GenericObjectDecryptor<R, D>
extends AbstractObjectDecryptor<R, D> {
    private static final long serialVersionUID = 1L;

    public GenericObjectDecryptor(CryptModel<Cipher, String, D> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
    }

    @Override
    protected Cipher newCipher(String key, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        return super.newCipher(key, algorithm, salt, iterationCount, operationMode);
    }

    public R decrypt(File encrypted) throws Exception {
        Objects.requireNonNull(encrypted);
        this.onBeforeDecrypt(encrypted);
        R genericObject = this.onDecrypt(encrypted);
        this.onAfterDecrypt(encrypted);
        return genericObject;
    }

    protected void onAfterDecrypt(File encrypted) {
        Objects.requireNonNull(encrypted);
    }

    protected void onBeforeDecrypt(File encrypted) {
        Objects.requireNonNull(encrypted);
    }

    private R onDecrypt(File encrypted) throws IOException, ClassNotFoundException {
        Objects.requireNonNull(encrypted);
        Object genericObject = null;
        Cipher cipher = (Cipher)this.getModel().getCipher();
        try (CipherInputStream cipherInputStream = new CipherInputStream(new BufferedInputStream(new FileInputStream(encrypted)), cipher);
             ObjectInputStream inputStream = new ObjectInputStream(cipherInputStream);){
            genericObject = inputStream.readObject();
            inputStream.close();
        }
        return (R)genericObject;
    }
}

