/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.file;

import io.github.astrapi69.crypt.data.model.CryptModel;
import io.github.astrapi69.mystic.crypt.core.AbstractObjectEncryptor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;

public class GenericObjectEncryptor<T, D>
extends AbstractObjectEncryptor<T, D> {
    private static final long serialVersionUID = 1L;
    private File encryptedFile;

    public GenericObjectEncryptor(CryptModel<Cipher, String, D> model, File encryptedFile) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
        Objects.requireNonNull(encryptedFile);
        this.encryptedFile = encryptedFile;
    }

    public File encrypt(T toEncrypt) throws Exception {
        Objects.requireNonNull(toEncrypt);
        this.onBeforeEncrypt(toEncrypt);
        this.onEncrypt(toEncrypt);
        this.onAfterEncrypt(toEncrypt);
        return this.encryptedFile;
    }

    protected File newEncryptedFile(String parent, String child) {
        return new File(parent, child);
    }

    protected void onAfterEncrypt(T toEncrypt) {
        Objects.requireNonNull(toEncrypt);
    }

    protected void onBeforeEncrypt(T toEncrypt) {
        Objects.requireNonNull(toEncrypt);
    }

    private void onEncrypt(T toEncrypt) throws IOException {
        Objects.requireNonNull(toEncrypt);
        Cipher cipher = (Cipher)this.getModel().getCipher();
        try (CipherOutputStream cipherOutputStream = new CipherOutputStream(new BufferedOutputStream(new FileOutputStream(this.encryptedFile)), cipher);
             ObjectOutputStream outputStream = new ObjectOutputStream(cipherOutputStream);){
            outputStream.writeObject(toEncrypt);
        }
    }

    @Override
    protected Cipher newCipher(String key, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        return super.newCipher(key, algorithm, salt, iterationCount, operationMode);
    }

    @Override
    public byte[] encrypt(byte[] toEncrypt) throws Exception {
        return new byte[0];
    }
}

