/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.file;

import io.github.astrapi69.crypt.data.factory.CipherFactory;
import io.github.astrapi69.crypt.data.model.CryptModel;
import io.github.astrapi69.crypt.data.model.CryptObjectDecorator;
import io.github.astrapi69.file.delete.DeleteFileExtensions;
import io.github.astrapi69.mystic.crypt.core.AbstractFileEncryptor;
import io.github.astrapi69.mystic.crypt.decorator.CryptObjectDecoratorExtensions;
import io.github.astrapi69.mystic.crypt.io.CryptoCipherInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.Normalizer;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FilenameUtils;

public class PBEFileEncryptor
extends AbstractFileEncryptor {
    public static final String DEFAULT_ENCRYPTED_FILE_EXTENSION = ".enc";
    private static final long serialVersionUID = 1L;
    private final boolean deleteFileAfterEncryption;
    private File encryptedFile;
    private String encryptedFileExtension = ".enc";

    public PBEFileEncryptor(CryptModel<Cipher, String, String> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this(model, null);
    }

    @Override
    public byte[] encrypt(byte[] toEncrypt) throws Exception {
        throw new UnsupportedOperationException("");
    }

    public PBEFileEncryptor(CryptModel<Cipher, String, String> model, File encryptedFile) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this(model, encryptedFile, DEFAULT_ENCRYPTED_FILE_EXTENSION);
    }

    public PBEFileEncryptor(CryptModel<Cipher, String, String> model, File encryptedFile, String encryptedFileExtension) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this(model, encryptedFile, encryptedFileExtension, false);
    }

    public PBEFileEncryptor(CryptModel<Cipher, String, String> model, File encryptedFile, String encryptedFileExtension, boolean deleteFileAfterEncryption) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
        this.encryptedFile = encryptedFile;
        this.encryptedFileExtension = encryptedFileExtension;
        this.deleteFileAfterEncryption = deleteFileAfterEncryption;
    }

    public File encrypt(File toEncrypt) throws Exception {
        List decorators;
        if (this.encryptedFile == null) {
            String filename = FilenameUtils.getBaseName((String)toEncrypt.getName());
            this.encryptedFile = this.newEncryptedFile(toEncrypt.getParent(), filename + this.encryptedFileExtension);
        }
        if ((decorators = this.getModel().getDecorators()) != null && !decorators.isEmpty()) {
            for (int i = 0; i < decorators.size(); ++i) {
                CryptObjectDecoratorExtensions.decorateFile(toEncrypt, (CryptObjectDecorator<String>)((CryptObjectDecorator)decorators.get(i)));
            }
        }
        try (CryptoCipherInputStream cis = new CryptoCipherInputStream(new FileInputStream(toEncrypt), (Cipher)this.getModel().getCipher());
             FileOutputStream out = new FileOutputStream(this.encryptedFile);){
            int c;
            while ((c = cis.read()) != -1) {
                ((OutputStream)out).write(c);
            }
        }
        if (this.deleteFileAfterEncryption) {
            DeleteFileExtensions.delete((File)toEncrypt);
        }
        return this.encryptedFile;
    }

    protected File newEncryptedFile(String parent, String child) {
        return new File(parent, child);
    }

    @Override
    protected Cipher newCipher(String privateKey, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        String normalizedPassword = Normalizer.normalize(privateKey, Normalizer.Form.NFC);
        Cipher cipher = CipherFactory.newPBECipher((char[])normalizedPassword.toCharArray(), (int)operationMode, (String)algorithm);
        return cipher;
    }
}

