/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.hex;

import io.github.astrapi69.check.Check;
import io.github.astrapi69.crypt.api.algorithm.AesAlgorithm;
import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import io.github.astrapi69.crypt.data.factory.KeySpecFactory;
import io.github.astrapi69.crypt.data.hex.HexExtensions;
import io.github.astrapi69.crypt.data.model.CryptModel;
import io.github.astrapi69.crypt.data.model.CryptObjectDecorator;
import io.github.astrapi69.mystic.crypt.core.AbstractStringDecryptor;
import io.github.astrapi69.mystic.crypt.decorator.CryptObjectDecoratorExtensions;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class HexableDecryptor
extends AbstractStringDecryptor {
    private static final long serialVersionUID = 1L;

    public HexableDecryptor(CryptModel<Cipher, String, String> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
    }

    public HexableDecryptor(String privateKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this(privateKey, (Algorithm)AesAlgorithm.AES);
    }

    public HexableDecryptor(String privateKey, Algorithm algorithm) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(privateKey);
        Check.get().notNull((Object)algorithm, "algorithm");
        this.getModel().setAlgorithm(algorithm);
    }

    public String decrypt(String encypted) throws Exception {
        byte[] dec = HexExtensions.decodeHex((char[])encypted.toCharArray());
        byte[] utf8 = ((Cipher)this.getModel().getCipher()).doFinal(dec);
        String string = new String(utf8, StandardCharsets.UTF_8);
        List decorators = this.getModel().getDecorators();
        if (decorators != null && !decorators.isEmpty()) {
            for (int i = decorators.size() - 1; 0 <= i; --i) {
                string = CryptObjectDecoratorExtensions.undecorateWithStringDecorator(string, (CryptObjectDecorator<String>)((CryptObjectDecorator)decorators.get(i)));
            }
        }
        return string;
    }

    @Override
    protected String newAlgorithm() {
        if (this.getModel().getAlgorithm() == null) {
            this.getModel().setAlgorithm((Algorithm)AesAlgorithm.AES);
        }
        return this.getModel().getAlgorithm().getAlgorithm();
    }

    @Override
    protected Cipher newCipher(String privateKey, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        SecretKeySpec skeySpec = KeySpecFactory.newSecretKeySpec((byte[])privateKey.getBytes(StandardCharsets.UTF_8), (String)algorithm);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(operationMode, skeySpec);
        return cipher;
    }
}

