/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.hex;

import io.github.astrapi69.check.Check;
import io.github.astrapi69.crypt.api.algorithm.AesAlgorithm;
import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import io.github.astrapi69.crypt.data.factory.KeySpecFactory;
import io.github.astrapi69.crypt.data.model.CryptModel;
import io.github.astrapi69.crypt.data.model.CryptObjectDecorator;
import io.github.astrapi69.mystic.crypt.core.AbstractStringEncryptor;
import io.github.astrapi69.mystic.crypt.decorator.CryptObjectDecoratorExtensions;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class HexableEncryptor
extends AbstractStringEncryptor {
    private static final long serialVersionUID = 1L;

    public HexableEncryptor(CryptModel<Cipher, String, String> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
    }

    public HexableEncryptor(String privateKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this(privateKey, (Algorithm)AesAlgorithm.AES);
    }

    @Override
    public byte[] encrypt(byte[] toEncrypt) throws Exception {
        throw new UnsupportedOperationException("");
    }

    public HexableEncryptor(String privateKey, Algorithm algorithm) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(privateKey);
        Check.get().notNull((Object)algorithm, "algorithm");
        this.getModel().setAlgorithm(algorithm);
    }

    public String encrypt(String string) throws InvalidKeyException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        List decorators = this.getModel().getDecorators();
        String decoratedString = string;
        if (decorators != null && !decorators.isEmpty()) {
            for (int i = 0; i < decorators.size(); ++i) {
                decoratedString = CryptObjectDecoratorExtensions.decorateWithStringDecorator(decoratedString, (CryptObjectDecorator<String>)((CryptObjectDecorator)decorators.get(i)));
            }
        }
        byte[] utf8 = decoratedString.getBytes(StandardCharsets.UTF_8);
        byte[] encrypt = ((Cipher)this.getModel().getCipher()).doFinal(utf8);
        char[] original = Hex.encodeHex((byte[])encrypt, (boolean)false);
        return new String(original);
    }

    @Override
    protected String newAlgorithm() {
        if (this.getModel().getAlgorithm() == null) {
            this.getModel().setAlgorithm((Algorithm)AesAlgorithm.AES);
        }
        return this.getModel().getAlgorithm().getAlgorithm();
    }

    @Override
    protected Cipher newCipher(String privateKey, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        SecretKeySpec skeySpec = KeySpecFactory.newSecretKeySpec((byte[])privateKey.getBytes(StandardCharsets.UTF_8), (String)algorithm);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(operationMode, skeySpec);
        return cipher;
    }
}

