/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.key;

import io.github.astrapi69.crypt.api.ByteArrayDecryptor;
import io.github.astrapi69.crypt.api.algorithm.AesAlgorithm;
import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import io.github.astrapi69.crypt.api.algorithm.key.KeyPairWithModeAndPaddingAlgorithm;
import io.github.astrapi69.crypt.data.factory.CipherFactory;
import io.github.astrapi69.crypt.data.model.AesRsaCryptModel;
import io.github.astrapi69.crypt.data.model.CryptModel;
import io.github.astrapi69.mystic.crypt.core.AbstractDecryptor;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.SerializationUtils;

public class PrivateKeyDecryptor
extends AbstractDecryptor<Cipher, PrivateKey, byte[]>
implements ByteArrayDecryptor {
    private static final long serialVersionUID = 1L;

    public PrivateKeyDecryptor(CryptModel<Cipher, PrivateKey, byte[]> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
    }

    public PrivateKeyDecryptor(PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(CryptModel.builder().key((Object)privateKey).build());
    }

    public byte[] decrypt(byte[] encrypted) throws Exception {
        AesRsaCryptModel cryptData = (AesRsaCryptModel)SerializationUtils.deserialize((byte[])encrypted);
        byte[] decryptedKey = ((Cipher)this.getModel().getCipher()).doFinal(cryptData.getEncryptedKey());
        Cipher cipher = this.newSymmetricCipher(decryptedKey, AesAlgorithm.AES.getAlgorithm(), 2);
        return cipher.doFinal(cryptData.getSymmetricKeyEncryptedObject());
    }

    private Cipher newSymmetricCipher(byte[] decryptedKey, String algorithm, int operationMode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec originalKey = new SecretKeySpec(decryptedKey, 0, decryptedKey.length, algorithm);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(operationMode, originalKey);
        return cipher;
    }

    @Override
    protected String newAlgorithm() {
        if (this.getModel().getAlgorithm() == null) {
            this.getModel().setAlgorithm((Algorithm)KeyPairWithModeAndPaddingAlgorithm.RSA_ECB_OAEPWithSHA1AndMGF1Padding);
        }
        return this.getModel().getAlgorithm().getAlgorithm();
    }

    @Override
    protected Cipher newCipher(PrivateKey key, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        Cipher cipher = CipherFactory.newCipher((String)algorithm);
        cipher.init(operationMode, key);
        return cipher;
    }
}

