/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.key;

import io.github.astrapi69.crypt.data.model.CryptModel;
import io.github.astrapi69.mystic.crypt.key.PrivateKeyDecryptor;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.io.Serializable;
import java.security.PrivateKey;
import java.util.Objects;
import javax.crypto.Cipher;
import org.apache.commons.lang3.SerializationUtils;

public class PrivateKeyGenericDecryptor<T extends Serializable> {
    private final PrivateKeyDecryptor decryptor;

    public PrivateKeyGenericDecryptor(CryptModel<Cipher, PrivateKey, byte[]> model) {
        this((PrivateKeyDecryptor)RuntimeExceptionDecorator.decorate(() -> new PrivateKeyDecryptor(model)));
    }

    public PrivateKeyGenericDecryptor(PrivateKey privateKey) {
        this((PrivateKeyDecryptor)RuntimeExceptionDecorator.decorate(() -> new PrivateKeyDecryptor(privateKey)));
    }

    public PrivateKeyGenericDecryptor(PrivateKeyDecryptor decryptor) {
        Objects.requireNonNull(decryptor);
        this.decryptor = decryptor;
    }

    public T decrypt(byte[] encrypted) throws Exception {
        byte[] decrypt = this.decryptor.decrypt(encrypted);
        return (T)((Serializable)SerializationUtils.deserialize((byte[])decrypt));
    }
}

