/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.key;

import io.github.astrapi69.crypt.api.ByteArrayEncryptor;
import io.github.astrapi69.crypt.api.algorithm.AesAlgorithm;
import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import io.github.astrapi69.crypt.api.algorithm.key.KeyPairWithModeAndPaddingAlgorithm;
import io.github.astrapi69.crypt.data.factory.CipherFactory;
import io.github.astrapi69.crypt.data.factory.SecretKeyFactoryExtensions;
import io.github.astrapi69.crypt.data.model.AesRsaCryptModel;
import io.github.astrapi69.crypt.data.model.CryptModel;
import io.github.astrapi69.mystic.crypt.core.AbstractEncryptor;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.SerializationUtils;

public class PublicKeyEncryptor
extends AbstractEncryptor<Cipher, PublicKey, byte[]>
implements ByteArrayEncryptor {
    private static final long serialVersionUID = 1L;
    private CryptModel<Cipher, SecretKey, String> symmetricKeyModel;

    public PublicKeyEncryptor(CryptModel<Cipher, PublicKey, byte[]> model, CryptModel<Cipher, SecretKey, String> symmetricKeyModel) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
        Objects.requireNonNull(symmetricKeyModel);
        this.symmetricKeyModel = symmetricKeyModel;
    }

    public PublicKeyEncryptor(PublicKey publicKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this((CryptModel<Cipher, PublicKey, byte[]>)CryptModel.builder().key((Object)publicKey).build(), (CryptModel<Cipher, SecretKey, String>)CryptModel.builder().key((Object)SecretKeyFactoryExtensions.newSecretKey((String)AesAlgorithm.AES.getAlgorithm(), (int)128)).algorithm((Algorithm)AesAlgorithm.AES).operationMode(1).build());
    }

    @Override
    public byte[] encrypt(byte[] toEncrypt) throws Exception {
        SecretKey symmetricKey = (SecretKey)this.symmetricKeyModel.getKey();
        Cipher symmetricKeyCipher = this.newSymmetricCipher(symmetricKey, this.symmetricKeyModel.getAlgorithm().getAlgorithm(), this.symmetricKeyModel.getOperationMode());
        byte[] symmetricKeyEncryptedBytes = symmetricKeyCipher.doFinal(toEncrypt);
        byte[] encryptedKey = ((Cipher)this.getModel().getCipher()).doFinal(symmetricKey.getEncoded());
        AesRsaCryptModel cryptData = AesRsaCryptModel.builder().encryptedKey(encryptedKey).symmetricKeyEncryptedObject(symmetricKeyEncryptedBytes).build();
        byte[] encryptedCryptData = SerializationUtils.serialize((Serializable)cryptData);
        return encryptedCryptData;
    }

    @Override
    protected String newAlgorithm() {
        if (this.getModel().getAlgorithm() == null) {
            this.getModel().setAlgorithm((Algorithm)KeyPairWithModeAndPaddingAlgorithm.RSA_ECB_OAEPWithSHA1AndMGF1Padding);
        }
        return this.getModel().getAlgorithm().getAlgorithm();
    }

    @Override
    protected Cipher newCipher(PublicKey key, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        Cipher cipher = CipherFactory.newCipher((String)algorithm);
        cipher.init(1, key);
        return cipher;
    }

    private Cipher newSymmetricCipher(SecretKey key, String algorithm, int operationMode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(operationMode, key);
        return cipher;
    }
}

