/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.key;

import io.github.astrapi69.crypt.data.model.CryptModel;
import io.github.astrapi69.mystic.crypt.key.PublicKeyEncryptor;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.io.Serializable;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.SerializationUtils;

public class PublicKeyGenericEncryptor<T extends Serializable> {
    private final PublicKeyEncryptor encryptor;

    public PublicKeyGenericEncryptor(CryptModel<Cipher, PublicKey, byte[]> model, CryptModel<Cipher, SecretKey, String> symmetricKeyModel) {
        this((PublicKeyEncryptor)RuntimeExceptionDecorator.decorate(() -> new PublicKeyEncryptor(model, symmetricKeyModel)));
    }

    public PublicKeyGenericEncryptor(PublicKey publicKey) {
        this((PublicKeyEncryptor)RuntimeExceptionDecorator.decorate(() -> new PublicKeyEncryptor(publicKey)));
    }

    public PublicKeyGenericEncryptor(PublicKeyEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public byte[] encrypt(T toEncrypt) throws Exception {
        return this.encryptor.encrypt(SerializationUtils.serialize(toEncrypt));
    }
}

